/*
 * Decompiled with CFR 0.152.
 */
package allegro;

import allegro.Allegro;
import com.siemens.mp.game.Sound;
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TunerCanvas
extends Canvas {
    private static int[] freq = new int[]{0, 209300, 197553, 186466, 176000, 166121, 156798, 147998, 139691, 131851, 124451, 117466, 110873, 0};
    private static String[] note = new String[]{"c#", "c", "h", "a#", "a", "g#", "g", "f#", "f", "e", "d#", "d", "c#", "c"};
    private static Sound sound = new Sound();
    private Image stimmgabel;
    private Image stimmnavi = null;
    private byte noteSel = (byte)4;
    private boolean makeSound = false;
    private int font1 = 0;
    private int teiler = 4;
    private static Font[] font = new Font[]{Font.getFont((int)64, (int)1, (int)8), Font.getFont((int)64, (int)1, (int)0), Font.getFont((int)64, (int)1, (int)16)};
    Allegro myAll = null;

    public TunerCanvas(Allegro a) {
        try {
            this.stimmgabel = Image.createImage((String)"allegro/stimmgabel.png");
        }
        catch (IOException ioExc) {
            System.out.print("IMAGE NOT FOUND");
        }
        try {
            this.stimmnavi = Image.createImage((String)"allegro/stimmnavi.png");
        }
        catch (IOException ioExc) {
            System.out.print("IMAGE NOT FOUND");
        }
        for (int i = 1; i <= 2; ++i) {
            if (font[i].charWidth('#') * 2 >= 19) continue;
            this.font1 = i;
        }
        this.myAll = a;
    }

    public void paint(Graphics g) {
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, super.getWidth(), this.getHeight());
        g.drawImage(this.stimmgabel, super.getWidth() / 2 - 48, super.getHeight() / 2 - 35, 20);
        g.drawImage(this.stimmnavi, super.getWidth() / 2 + 19, super.getHeight() / 2 - 3, 17);
        g.setFont(font[this.font1]);
        g.setColor(69, 63, 51);
        g.drawString(note[this.noteSel], super.getWidth() / 2 + 19, super.getHeight() / 2 + font[this.font1].getHeight() / 2, 33);
        g.setFont(font[0]);
        g.setColor(138, 138, 138);
        g.drawString(note[this.noteSel + 1], super.getWidth() / 2 + 4, super.getHeight() / 2 + font[0].getHeight() / 2, 40);
        g.drawString(note[this.noteSel - 1], super.getWidth() / 2 + 34, super.getHeight() / 2 + font[0].getHeight() / 2, 36);
        g.setColor(0);
        if (this.makeSound) {
            g.drawString("stop", 2, super.getHeight(), 36);
        } else {
            g.drawString("start", 2, super.getHeight(), 36);
        }
        g.drawString("back", super.getWidth() - 2, super.getHeight(), 40);
    }

    protected void keyPressed(int keyCode) {
        if (keyCode == -4 || keyCode == -12) {
            this.myAll.gotoScreen(0);
        } else {
            keyCode = this.getGameAction(keyCode);
            switch (keyCode) {
                case 1: {
                    if (this.teiler <= 2) break;
                    this.teiler /= 2;
                    break;
                }
                case 6: {
                    if (this.teiler >= 16) break;
                    this.teiler *= 2;
                    break;
                }
                case 2: {
                    this.noteSel = (byte)(this.noteSel + 1);
                    if (this.noteSel <= 12 || this.teiler >= 16) break;
                    this.noteSel = 1;
                    this.teiler *= 2;
                    break;
                }
                case 5: {
                    this.noteSel = (byte)(this.noteSel - 1);
                    if (this.noteSel >= 1 || this.teiler <= 2) break;
                    this.noteSel = (byte)12;
                    this.teiler /= 2;
                    break;
                }
                case 8: {
                    boolean bl = this.makeSound = !this.makeSound;
                }
            }
            if (this.makeSound) {
                Sound.playTone((int)(freq[this.noteSel] / this.teiler / 100), (int)-1);
            } else {
                Sound.playTone((int)(freq[this.noteSel] / this.teiler / 100), (int)1);
            }
            this.repaint();
        }
    }
}

