/*
 * Decompiled with CFR 0.152.
 */
package allegro;

import allegro.Allegro;
import allegro.Beat;
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CountCanvas
extends Canvas {
    private int bpm;
    private int number;
    private long time;
    private boolean pressed = false;
    private static Image img_up = null;
    private static Image img_dn = null;
    private static final int[] sin = new int[]{0, 4, 8, 11, 14, 15, 16, 15, 14, 11, 8, 4, 0, -4, -8, -11, -14, -15, -16, -15, -14, -11, -8, -4, 0, 4, 8, 11, 14, 15, 16};
    Beat beat = null;
    Allegro myAll = null;

    public CountCanvas(Allegro a, Beat bt) {
        this.beat = bt;
        this.myAll = a;
        this.bpm = 0;
        this.number = 0;
        this.time = 0L;
        try {
            img_up = Image.createImage((String)"allegro/beatcounter.png");
        }
        catch (IOException ioExc) {
            System.out.print("IMAGE NOT FOUND");
        }
        try {
            img_dn = Image.createImage((String)"allegro/beatcounter_dn.png");
        }
        catch (IOException ioExc) {
            System.out.print("IMAGE NOT FOUND");
        }
    }

    public void paint(Graphics g) {
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, super.getWidth(), super.getHeight());
        g.drawImage(img_up, 3, 3, 20);
        if (this.pressed) {
            g.drawImage(img_dn, 3, 3, 20);
        }
        g.setColor(70, 70, 60);
        g.drawLine(27, 39, 26 + sin[this.bpm / 10], 39 - sin[this.bpm / 10 + 6]);
        g.drawLine(26, 39, 26 + sin[this.bpm / 10], 39 - sin[this.bpm / 10 + 6]);
        g.setColor(100, 100, 80);
        g.drawLine(26, 38, 26 + sin[this.bpm / 10], 39 - sin[this.bpm / 10 + 6]);
        g.setColor(0);
        String str = null;
        String act = null;
        if (this.bpm == 0) {
            str = "press a\n  key";
            act = "back";
        } else {
            str = "BPM:".concat(String.valueOf(String.valueOf(String.valueOf(this.bpm))));
            act = "use";
        }
        g.setFont(Font.getFont((int)64, (int)1, (int)0));
        g.drawString(str, 53, super.getHeight() / 2, 36);
        g.setColor(70, 70, 70);
        g.drawString("reset", 2, super.getHeight(), 36);
        g.drawString(act, super.getWidth() - 2, super.getHeight(), 40);
    }

    protected void keyPressed(int keyCode) {
        if (keyCode == -1) {
            this.bpm = 0;
            this.number = 0;
        } else if (keyCode == -12) {
            this.bpm = 0;
            this.number = 0;
            this.myAll.gotoScreen(0);
        } else if (keyCode == -4) {
            if (this.bpm == 0) {
                this.myAll.gotoScreen(0);
            } else {
                this.beat.bpm = this.bpm;
                this.bpm = 0;
                this.number = 0;
                this.myAll.gotoScreen(2);
            }
        } else {
            if (this.number == 0) {
                this.time = System.currentTimeMillis();
            } else {
                this.bpm = (int)Math.abs((long)60000 / ((System.currentTimeMillis() - this.time) / (long)this.number));
            }
            if (this.bpm > 240) {
                this.bpm = 240;
            }
            ++this.number;
            this.pressed = true;
        }
        this.repaint();
    }

    protected void keyReleased(int keyCode) {
        this.pressed = false;
        this.repaint(0, 10, 20, 20);
    }
}

