/*
 * Decompiled with CFR 0.152.
 */
package allegro;

import allegro.Allegro;
import allegro.Beat;
import allegro.ClickThread;
import com.siemens.mp.game.Light;
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MetroCanvas
extends Canvas {
    private int rectWidth;
    private int rectHeight;
    private int usedBottom;
    private int usedTop;
    private int vcenter;
    private byte beatFont = 0;
    private byte speedFont = (byte)3;
    private boolean repaint = true;
    private Font[] font;
    private String str = "";
    private Image metropng = null;
    private ClickThread click = null;
    int show;
    Beat beat = null;
    Allegro myAll = null;
    private static int[] px = new int[]{20, 20, 19, 17, 15, 13, 10, 7, 3, 0, -3, -7, -10, -13, -15, -17, -19, -20, -20, -20, -19, -17, -15, -13, -10, -7, -3, 0};

    public MetroCanvas(Allegro a, Beat b) {
        this.myAll = a;
        this.beat = b;
        this.show = this.beat.bpm;
        this.click = new ClickThread(this.beat, this);
        this.click.start();
        try {
            this.metropng = Image.createImage((String)"allegro/metronom.png");
        }
        catch (IOException ioExc) {
            System.out.print("IMAGE NOT FOUND");
        }
        this.font = new Font[3];
        this.font[0] = Font.getFont((int)64, (int)1, (int)8);
        this.font[1] = Font.getFont((int)64, (int)1, (int)0);
        this.font[2] = Font.getFont((int)64, (int)1, (int)16);
        this.rectWidth = super.getWidth() / 16;
        this.rectHeight = this.rectWidth * 3 / 2;
        this.usedTop = this.rectHeight + this.rectWidth;
        this.usedBottom = this.font[0].getHeight() + 1;
        this.vcenter = super.getHeight() / 2 + (this.usedTop - this.usedBottom) / 2;
        for (int i = 0; i < 3; i = (int)((byte)(i + 1))) {
            for (int s = 0; s < i; s = (int)((byte)(s + 1))) {
                if (this.font[i].getHeight() * 2 + this.font[s].getHeight() * 2 >= super.getHeight() - this.usedTop - this.usedBottom - 4) continue;
                this.beatFont = (byte)i;
                this.speedFont = (byte)s;
            }
        }
    }

    public void paint(Graphics g) {
        if (this.beat.metrograf) {
            if (this.repaint) {
                this.repaint = false;
                g.setColor(255, 255, 255);
                g.fillRect(0, 0, super.getWidth(), this.getHeight());
                g.setColor(101, 57, 6);
                g.setFont(this.font[0]);
                this.str = new String(String.valueOf(this.show));
                if (this.show < 30) {
                    g.setColor(128, 128, 128);
                    this.str = String.valueOf(String.valueOf(this.str)).concat("?");
                }
                g.drawString(this.str, super.getWidth() / 2 + 40, super.getHeight() / 2, 40);
            }
            g.setColor(0);
            g.setFont(this.font[0]);
            if (this.beat.pause) {
                g.drawString("start", 2, super.getHeight(), 36);
            } else {
                g.drawString("stop", 2, super.getHeight(), 36);
            }
            g.drawImage(this.metropng, super.getWidth() / 2, super.getHeight() / 2 - 33, 17);
            g.drawLine(super.getWidth() / 2 - 1, super.getHeight() / 2 + 5, super.getWidth() / 2 + px[this.beat.phase], super.getHeight() / 2 - 24 - Math.abs(px[this.beat.phase + 9] / 3));
            g.drawLine(super.getWidth() / 2, super.getHeight() / 2 + 5, super.getWidth() / 2 + px[this.beat.phase], super.getHeight() / 2 - 24 - Math.abs(px[this.beat.phase + 9] / 3));
        } else {
            if (this.beat.blink) {
                g.setColor(0, 0, 0);
            } else {
                g.setColor(255, 255, 255);
            }
            g.fillRect(0, 0, super.getWidth(), this.getHeight());
            if (this.beat.blink) {
                g.setColor(255, 255, 255);
            } else {
                g.setColor(0, 0, 0);
            }
            if (this.rectWidth > 2) {
                for (int i = 1; i <= this.beat.bar; ++i) {
                    g.drawRect(i * this.rectWidth - this.rectWidth / 2, this.rectWidth / 2, this.rectWidth - 2, this.rectHeight);
                }
                if (this.beat.current != 0) {
                    g.fillRect(this.beat.current * this.rectWidth - this.rectWidth / 2, this.rectWidth / 2, this.rectWidth - 2, this.rectHeight);
                }
            }
            g.setFont(this.font[0]);
            if (this.beat.pause) {
                g.drawString("start", 2, super.getHeight(), 36);
            } else {
                g.drawString("stop", 2, super.getHeight(), 36);
            }
            g.setFont(this.font[this.beatFont]);
            this.str = new String("BPM:".concat(String.valueOf(String.valueOf(String.valueOf(this.show)))));
            if (this.show < 30) {
                g.setColor(128, 128, 128);
                this.str = String.valueOf(String.valueOf(this.str)).concat("?");
            }
            g.drawString(this.str, super.getWidth() / 2, this.vcenter, 33);
            if (this.beat.blink) {
                g.setColor(255, 255, 255);
            } else {
                g.setColor(0, 0, 0);
            }
            this.str = "Bars:".concat(String.valueOf(String.valueOf(String.valueOf(this.beat.bar))));
            g.drawString(this.str, super.getWidth() / 2, this.vcenter + 1, 17);
            if (this.speedFont < 2) {
                this.str = "grave";
                if (this.beat.bpm > 39) {
                    this.str = "largo";
                }
                if (this.beat.bpm > 47) {
                    this.str = "adagio";
                }
                if (this.beat.bpm > 64) {
                    this.str = "andante";
                }
                if (this.beat.bpm > 84) {
                    this.str = "moderato";
                }
                if (this.beat.bpm > 104) {
                    this.str = "allegretto";
                }
                if (this.beat.bpm > 119) {
                    this.str = "allegro";
                }
                if (this.beat.bpm > 139) {
                    this.str = "vivace";
                }
                if (this.beat.bpm > 159) {
                    this.str = "presto";
                }
                if (this.beat.bpm > 199) {
                    this.str = "prestissimo";
                }
                g.setFont(this.font[this.speedFont]);
                g.setColor(128, 128, 128);
                g.drawString(this.str, super.getWidth() / 2, this.vcenter + this.font[this.beatFont].getHeight() + 2, 17);
                if (this.beat.name != null) {
                    g.drawString(String.valueOf(String.valueOf(new StringBuffer("[").append(this.beat.name).append("]"))), super.getWidth() / 2, this.vcenter - (this.font[this.beatFont].getHeight() + 2), 33);
                }
            }
        }
    }

    protected void keyRepeated(int keyCode) {
        this.keyAction(keyCode, true);
    }

    protected void keyPressed(int keyCode) {
        this.keyAction(keyCode, false);
    }

    void keyAction(int keyCode, boolean pressed) {
        this.repaint = true;
        if (keyCode < 58 && keyCode > 47) {
            if (this.show == this.beat.bpm) {
                this.show = keyCode - 48;
            } else {
                this.show *= 10;
                this.show += keyCode - 48;
            }
            if (this.show > 240) {
                this.show = 240;
            }
            if (this.show > 29) {
                this.beat.bpm = this.show;
            }
        } else if (keyCode == -12) {
            this.beat.pause = true;
            this.beat.waits = 1000;
            Light.setLightOff();
            this.myAll.gotoScreen(0);
        } else if (keyCode == 35) {
            this.beat.metrograf = !this.beat.metrograf;
            this.myAll.settingList.setSelectedIndex(0, this.beat.metrograf);
        } else {
            keyCode = this.getGameAction(keyCode);
            switch (keyCode) {
                case 1: {
                    if (this.beat.bpm >= 239) break;
                    if (this.beat.bpm % 5 == 0 && pressed) {
                        this.beat.bpm += 4;
                    }
                    ++this.beat.bpm;
                    this.show = this.beat.bpm;
                    break;
                }
                case 6: {
                    if (this.beat.bpm <= 30) break;
                    if (this.beat.bpm % 5 == 0 && pressed) {
                        this.beat.bpm -= 4;
                    }
                    --this.beat.bpm;
                    this.show = this.beat.bpm;
                    break;
                }
                case 2: {
                    if (this.beat.bar <= 2) break;
                    this.beat.bar = (byte)(this.beat.bar - 1);
                    this.show = this.beat.bpm;
                    break;
                }
                case 5: {
                    if (this.beat.bar >= 16) break;
                    this.beat.bar = (byte)(this.beat.bar + 1);
                    this.show = this.beat.bpm;
                    break;
                }
                case 8: {
                    this.beat.pause = !this.beat.pause;
                    this.beat.blink = false;
                    this.beat.current = 0;
                }
            }
        }
        this.repaint();
    }
}

