/*
 * Decompiled with CFR 0.152.
 */
package nbs_tetris;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import nbs_tetris.SavedGame;
import nbs_tetris.tetrisMIDlet;

public class SavedGames
extends List
implements CommandListener {
    public static final String LAST_GAME_NAME = "x|||&&|||x";
    public static final String RMS_SAVED_GAMES_LIST = "g";
    private Command cancel;
    private tetrisMIDlet midlet = tetrisMIDlet.getInstance();
    private boolean names_stage = true;
    private SavedGame saved_game;
    private Hashtable saved_games_list = new Hashtable();

    public SavedGames() {
        super("", 3);
        this.loadNames();
        this.setCommandListener(this);
        this.cancel = new Command(this.midlet.getI18n("cancel"), 1, 1);
        this.addCommand(this.cancel);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == SELECT_COMMAND) {
            if (this.names_stage) {
                int n = this.getSelectedIndex();
                this.saved_game = n > 0 ? (SavedGame)this.saved_games_list.get(this.getString(n)) : (SavedGame)this.saved_games_list.get(LAST_GAME_NAME);
                this.deleteAllItems();
                this.removeCommand(this.cancel);
                this.append(this.midlet.getI18n("load_game"), null);
                if (n > 0) {
                    this.append(this.midlet.getI18n("del_game"), null);
                }
                this.append(this.midlet.getI18n("cancel"), null);
                this.names_stage = false;
            } else {
                switch (this.getSelectedIndex()) {
                    case 0: {
                        this.midlet.getTetris().loadGame(this.saved_game.id);
                        break;
                    }
                    case 1: {
                        try {
                            RecordStore recordStore = RecordStore.openRecordStore((String)"sg", (boolean)false);
                            recordStore.deleteRecord(this.saved_game.id);
                            recordStore.closeRecordStore();
                            recordStore = RecordStore.openRecordStore((String)RMS_SAVED_GAMES_LIST, (boolean)false);
                            recordStore.deleteRecord(this.saved_game.name_id);
                            recordStore.closeRecordStore();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.names_stage = true;
                        this.deleteAllItems();
                        this.saved_games_list.clear();
                        this.loadNames();
                        this.addCommand(command);
                        break;
                    }
                    case 2: {
                        this.names_stage = true;
                        this.deleteAllItems();
                        this.saved_games_list.clear();
                        this.loadNames();
                        this.addCommand(command);
                    }
                }
            }
        } else if (command == this.cancel) {
            this.midlet.showMenu();
        }
    }

    private void deleteAllItems() {
        while (this.size() > 0) {
            this.delete(0);
        }
    }

    public Hashtable getSaved_games_list() {
        return this.saved_games_list;
    }

    private void loadNames() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)RMS_SAVED_GAMES_LIST, (boolean)false);
            if (recordStore.getNumRecords() > 0) {
                this.append(this.midlet.getI18n("last_game"), null);
            }
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                byte[] byArray = recordStore.getRecord(n);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                SavedGame savedGame = new SavedGame(dataInputStream.readUTF(), n, dataInputStream.readInt());
                this.saved_games_list.put(savedGame.name, savedGame);
                if (savedGame.name.equals(LAST_GAME_NAME)) continue;
                this.append(savedGame.name, null);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {}
    }
}

