/*
 * Decompiled with CFR 0.152.
 */
package nbs_tetris;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import nbs_tetris.HighScores;
import nbs_tetris.NewScore;
import nbs_tetris.PaintTask;
import nbs_tetris.SaveGame;
import nbs_tetris.SaveScoresForm;
import nbs_tetris.SavedGame;
import nbs_tetris.SavedGames;
import nbs_tetris.TetrisItem;
import nbs_tetris.Utils;
import nbs_tetris.tetrisMIDlet;

public class TetrisView
extends Canvas
implements CommandListener {
    private byte[] DIGIT_IMAGES_POS;
    public byte[] KEYS = null;
    public static final byte KEYS_COUNT = 5;
    public static final byte KEY_MOVE2DOWN = 2;
    public static final byte KEY_MOVE2LEFT = 0;
    public static final byte KEY_MOVE2RIGHT = 1;
    public static final byte KEY_PAUSE = 4;
    public static final byte KEY_ROTATE = 3;
    private static final byte LINE_COST = 5;
    private byte NEW_SCORES_FLAGS_STEP;
    public static final byte ORIENTATION_HORIZONTAL = 1;
    public static final byte ORIENTATION_VERTICAL = 2;
    public static final String RMS_KEY_PREFERENCES = "keys";
    public static final String RMS_SAVED_GAMES = "sg";
    private int anim_style = -1;
    private int bck_prohibition_elements;
    private int cell_size;
    private TetrisItem cur_item;
    private Image digit_images = null;
    private Command end_game;
    private Command exit_game;
    private boolean full_repaint = false;
    private int game_area_height;
    private int[] game_area_lt;
    private int game_area_width;
    private boolean game_ended = false;
    protected boolean game_over = false;
    protected int[][] glass_map;
    private int height;
    private long high_scores = 0L;
    private int initial_rate = 1000;
    private boolean keys_settings_changed = false;
    private byte level = 0;
    private long low_scores = 0L;
    private Image lvl_img = null;
    private tetrisMIDlet midlet = tetrisMIDlet.getInstance();
    private int minimum_rate = 100;
    private Command new_game;
    private Vector new_scores;
    private TetrisItem next_item;
    private int[] next_item_lt;
    private int next_level_delta = 100;
    private int next_level_devider = 100;
    private int num_cols = 10;
    private int num_rows = 0;
    private Image offscreen = null;
    private byte orientation;
    private Command pause_game;
    protected boolean paused = false;
    private int prohibition_elements;
    private int rate;
    private Command return2game;
    private Command save_game;
    private long score = 0L;
    private boolean show_animation_on_removing_line = true;
    private boolean show_grid = true;
    private int start_pixel = 0;
    private byte[] temp;
    private PaintTask tetris_task;
    private Timer timer;
    private boolean usenonstdel_on_nextlvl;
    private int width;

    public TetrisView() {
        this.height = this.getHeight();
        this.width = this.getWidth();
        this.orientation = (byte)2;
        this.next_item_lt = new int[]{0, 0};
        this.game_area_lt = new int[]{0, 0};
        this.DIGIT_IMAGES_POS = new byte[]{0, 6, 10, 16, 22, 28, 34, 40, 46, 52, 58};
        this.new_scores = new Vector();
        this.NEW_SCORES_FLAGS_STEP = (byte)4;
        this.temp = new byte[]{0, 0, 0, 0};
        if (!this.isDoubleBuffered() || !this.midlet.isColor_phone()) {
            this.offscreen = Image.createImage((int)this.getWidth(), (int)this.getHeight());
        }
        this.readKeysPreferences();
        this.setDefaultOptions();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.new_game) {
            this.newGame(true);
        } else if (command == this.save_game) {
            this.timer.cancel();
            this.timer = null;
            this.midlet.getDisplay().setCurrent((Displayable)new SaveGame());
        } else if (command == this.end_game) {
            this.endGame();
            this.saveGame("x|||&&|||x", false);
            this.midlet.showMenu();
        } else if (command == this.return2game) {
            this.continueGame();
        } else if (command == this.exit_game) {
            this.endGame();
            this.saveGame("x|||&&|||x", false);
            this.midlet.destroyApp(false);
        } else if (command == this.pause_game) {
            this.midlet.pauseApp();
        }
    }

    public void continueGame() {
        this.full_repaint = true;
        if (this.timer == null) {
            this.timer = new Timer();
            this.tetris_task = new PaintTask(this);
            this.timer.scheduleAtFixedRate((TimerTask)this.tetris_task, this.rate / 30, (long)(this.rate / 30));
        }
        this.paused = false;
    }

    public static int drawString(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        Font font = Font.getFont((int)32, (int)0, (int)16);
        if (font.stringWidth(string) - 6 > n && (font = Font.getFont((int)32, (int)0, (int)0)).stringWidth(string) - 6 > n) {
            font = Font.getFont((int)32, (int)0, (int)8);
        }
        graphics.setColor(n2);
        graphics.setFont(font);
        graphics.drawString(string, n3, n4, 17);
        return font.getHeight();
    }

    public synchronized void endGame() {
        this.timer.cancel();
        this.timer = null;
        this.game_ended = true;
        if (this.usenonstdel_on_nextlvl) {
            this.prohibition_elements = this.bck_prohibition_elements;
        }
        this.repaint();
        this.serviceRepaints();
    }

    public int getCell_size() {
        return this.cell_size;
    }

    public TetrisItem getCur_item() {
        return this.cur_item;
    }

    public int getGame_area_height() {
        return this.game_area_height;
    }

    public int getGame_area_width() {
        return this.game_area_width;
    }

    public int[][] getGlass_map() {
        return this.glass_map;
    }

    public int getInitial_rate() {
        return this.initial_rate;
    }

    public synchronized byte getLevel() {
        return this.level;
    }

    public int getMinimum_rate() {
        return this.minimum_rate;
    }

    public TetrisItem getNext_item() {
        return this.next_item;
    }

    public int[] getNext_item_lt() {
        return this.next_item_lt;
    }

    public int getNext_level_delta() {
        return this.next_level_delta;
    }

    public int getNext_level_devider() {
        return this.next_level_devider;
    }

    public int getNum_cols() {
        return this.num_cols;
    }

    public int getNum_rows() {
        return this.num_rows;
    }

    public byte getOrientation() {
        return this.orientation;
    }

    public int getProhibition_elements() {
        return this.prohibition_elements;
    }

    protected void hideNotify() {
        if (!this.midlet.isSiemens_bug_fix()) {
            super.hideNotify();
            this.pauseGame();
            this.paused = true;
        }
    }

    private void init() {
        if (this.orientation == 1) {
            this.cell_size = (this.width - 4) / 14;
            this.game_area_lt[0] = this.cell_size * 4 + 2 + (this.width - 4) % (this.num_cols + 4);
            this.game_area_lt[1] = 0;
            this.game_area_width = this.cell_size * this.num_cols;
            this.game_area_height = this.height - 6;
            while (this.width - this.game_area_width - this.cell_size * 4 > this.cell_size) {
                this.game_area_width += this.cell_size;
                this.game_area_lt[0] = this.game_area_lt[0] - this.cell_size;
                ++this.num_cols;
            }
            this.next_item_lt[0] = (this.width - this.game_area_width - this.cell_size * 4) / 2 - 1;
            this.next_item_lt[1] = 1;
            this.num_rows = this.game_area_height / this.cell_size;
            this.start_pixel = this.cell_size - this.game_area_height % this.cell_size;
        } else {
            this.cell_size = (this.height - 4) / 14;
            this.game_area_lt[0] = 1;
            this.game_area_lt[1] = this.cell_size * 4 + 2;
            this.game_area_width = this.width;
            this.game_area_height = this.cell_size * this.num_cols;
            while (this.height - this.game_area_height - this.cell_size * 4 - 2 > this.cell_size) {
                this.game_area_height += this.cell_size;
                ++this.num_cols;
            }
            this.next_item_lt[0] = this.width - this.cell_size * 4 - 1;
            int n = this.height - this.game_area_height - this.cell_size * 4 - 2;
            if (n > 0) {
                this.game_area_lt[1] = this.game_area_lt[1] + (n - 1);
                this.next_item_lt[1] = (this.game_area_lt[1] - this.cell_size * 4) / 2;
            } else {
                this.next_item_lt[1] = 1;
            }
            this.num_rows = this.game_area_width / this.cell_size;
            this.start_pixel = this.game_area_width % this.cell_size;
        }
        this.glass_map = new int[this.num_cols][this.num_rows];
        this.next_item = new TetrisItem(this);
        this.next_item.setTop(this.next_item_lt[0], this.next_item_lt[1]);
        this.cur_item = new TetrisItem(this);
        byte[] byArray = this.cur_item.getMap();
        int n = byArray.length - 1;
        while (n > -1) {
            if (byArray[n] != 0) break;
            --n;
        }
        this.cur_item.setCell(Utils.getRandomNumber(this.num_cols - this.cur_item.getMap().length - 1), -n);
        if (this.orientation == 1) {
            this.cur_item.setTop(this.game_area_lt[0] + 1, this.game_area_lt[1] + 1 - this.start_pixel);
        } else {
            this.cur_item.setTop(this.game_area_lt[0], this.game_area_lt[1] + 2);
        }
    }

    public boolean isKeys_settings_changed() {
        return this.keys_settings_changed;
    }

    public boolean isShow_animation_on_removing_line() {
        return this.show_animation_on_removing_line;
    }

    public boolean isShow_grid() {
        return this.show_grid;
    }

    public boolean isUsenonstdel_on_nextlvl() {
        return this.usenonstdel_on_nextlvl;
    }

    protected synchronized void keyPressed(int n) {
        if (!this.game_over) {
            if (this.timer != null) {
                if (n == this.KEYS[0]) {
                    if (this.orientation == 1) {
                        this.getCur_item().moveLeft();
                    } else {
                        this.getCur_item().moveRight();
                    }
                    this.repaint();
                } else if (n == this.KEYS[1]) {
                    if (this.orientation == 1) {
                        this.getCur_item().moveRight();
                    } else {
                        this.getCur_item().moveLeft();
                    }
                    this.repaint();
                } else if (n == this.KEYS[2]) {
                    byte by = 1;
                    while (by == 1) {
                        by = this.stepElement();
                        this.repaint();
                    }
                } else if (n == this.KEYS[4]) {
                    this.pauseGame();
                    this.repaint();
                } else if (n == this.KEYS[3]) {
                    this.cur_item.rotateElement(this.temp);
                    this.repaint();
                }
            } else if (n == this.KEYS[4] && this.paused) {
                this.continueGame();
            }
        } else if (this.score > this.low_scores) {
            SaveScoresForm saveScoresForm = new SaveScoresForm(this.score);
            this.midlet.getDisplay().setCurrent((Displayable)saveScoresForm);
        } else {
            this.midlet.showMenu();
        }
    }

    protected void keyRepeated(int n) {
        if (this.timer != null) {
            if (n == this.KEYS[0]) {
                if (this.orientation == 1) {
                    this.tetris_task.setKey(this.KEYS[0]);
                } else {
                    this.tetris_task.setKey(this.KEYS[1]);
                }
            } else if (n == this.KEYS[1]) {
                if (this.orientation == 1) {
                    this.tetris_task.setKey(this.KEYS[1]);
                } else {
                    this.tetris_task.setKey(this.KEYS[0]);
                }
            }
        }
    }

    public void loadGame(int n) {
        this.newGame(false);
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)RMS_SAVED_GAMES, (boolean)false);
            byte[] byArray = recordStore.getRecord(n);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.orientation = dataInputStream.readByte();
            this.cur_item.readFromStream(dataInputStream);
            this.cur_item.setOrientation(this.orientation);
            this.next_item.readFromStream(dataInputStream);
            this.next_item.setOrientation(this.orientation);
            this.score = dataInputStream.readLong();
            this.level = dataInputStream.readByte();
            try {
                int n2 = this.glass_map[0].length - 1;
                while (n2 > -1) {
                    int n3 = 0;
                    while (n3 < this.glass_map.length) {
                        this.glass_map[n3][n2] = dataInputStream.readInt();
                        ++n3;
                    }
                    --n2;
                }
            }
            catch (EOFException eOFException) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.midlet.getDisplay().setCurrent((Displayable)this);
        this.continueGame();
    }

    public void makeCommands() {
        this.pause_game = new Command(this.midlet.getI18n("pause_game"), 1, 0);
        this.new_game = new Command(this.midlet.getI18n("new_game"), 1, 1);
        this.save_game = new Command(this.midlet.getI18n("save_game"), 1, 1);
        this.end_game = new Command(this.midlet.getI18n("end_game"), 1, 2);
        this.return2game = new Command(this.midlet.getI18n("return_game"), 1, 3);
        this.exit_game = new Command(this.midlet.getI18n("exit_cmd"), 1, 4);
        this.setCommandListener(this);
        this.addCommand(this.new_game);
        this.addCommand(this.save_game);
        this.addCommand(this.end_game);
        this.addCommand(this.return2game);
        this.addCommand(this.exit_game);
    }

    public synchronized void moveNewScoresFlags() {
        if (this.new_scores.size() > 0) {
            Enumeration enumeration = this.new_scores.elements();
            while (enumeration.hasMoreElements()) {
                NewScore newScore = (NewScore)enumeration.nextElement();
                if (this.orientation == 1) {
                    newScore.setY(newScore.getY() - this.NEW_SCORES_FLAGS_STEP);
                    if (newScore.getY() >= this.game_area_lt[1] - 4) continue;
                    this.new_scores.removeElementAt(0);
                    enumeration = this.new_scores.elements();
                    continue;
                }
                newScore.setX(newScore.getX() + this.NEW_SCORES_FLAGS_STEP);
                if (newScore.getX() <= this.game_area_lt[0] + this.cell_size * this.num_rows + 10) continue;
                this.new_scores.removeElementAt(0);
                enumeration = this.new_scores.elements();
            }
        }
    }

    public void newGame(boolean bl) {
        this.full_repaint = true;
        this.game_ended = false;
        if (this.orientation == 2 && this.digit_images == null) {
            try {
                this.digit_images = Image.createImage((String)"/res/numb.png");
                this.lvl_img = Image.createImage((String)"/res/lvl.png");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.usenonstdel_on_nextlvl) {
            this.bck_prohibition_elements = this.prohibition_elements;
            this.prohibition_elements = 0;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.init();
        this.next_item.randomize();
        this.cur_item.randomize();
        this.cur_item.setCell(Utils.getRandomNumber(this.num_cols - this.cur_item.getMap().length - 1), -this.cur_item.getMap().length + 1);
        this.game_over = false;
        this.score = 0L;
        this.level = 0;
        this.rate = this.initial_rate;
        HighScores highScores = new HighScores();
        this.high_scores = highScores.getHighScores();
        this.low_scores = highScores.getLowScores();
        this.new_scores.removeAllElements();
        if (bl) {
            this.continueGame();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paint(Graphics graphics) {
        Graphics graphics2 = null;
        if (this.offscreen != null) {
            graphics2 = graphics;
            graphics = this.offscreen.getGraphics();
        }
        TetrisView tetrisView = this;
        synchronized (tetrisView) {
            int n;
            int n2;
            if (this.full_repaint) {
                this.paintClipRect(graphics);
                if (this.midlet.isColor_phone()) {
                    graphics.setColor(204);
                } else {
                    graphics.setColor(1);
                }
                if (this.orientation == 1) {
                    graphics.drawLine(this.game_area_lt[0], this.game_area_lt[1], this.game_area_lt[0], this.game_area_lt[1] + this.game_area_height);
                    graphics.drawLine(this.game_area_lt[0] - 1, this.game_area_lt[1], this.game_area_lt[0] - 1, this.game_area_lt[1] + this.game_area_height);
                    graphics.drawLine(this.game_area_lt[0] + this.game_area_width, this.game_area_lt[1], this.game_area_lt[0] + this.game_area_width, this.game_area_lt[1] + this.game_area_height);
                    graphics.drawLine(this.game_area_lt[0] + this.game_area_width + 1, this.game_area_lt[1], this.game_area_lt[0] + this.game_area_width + 1, this.game_area_lt[1] + this.game_area_height);
                    graphics.drawLine(this.game_area_lt[0] - 1, this.game_area_lt[1] + this.game_area_height, this.game_area_lt[0] + this.game_area_width + 1, this.game_area_lt[1] + this.game_area_height);
                    graphics.drawLine(this.game_area_lt[0] - 1, this.game_area_lt[1] + this.game_area_height + 1, this.game_area_lt[0] + this.game_area_width + 1, this.game_area_lt[1] + this.game_area_height + 1);
                } else {
                    graphics.drawLine(this.game_area_lt[0] - 1, this.game_area_lt[1], this.game_area_lt[0] + this.game_area_width + 1, this.game_area_lt[1]);
                    graphics.drawLine(this.game_area_lt[0] - 1, this.game_area_lt[1] - 1, this.game_area_lt[0] + this.game_area_width + 1, this.game_area_lt[1] - 1);
                    graphics.drawLine(this.game_area_lt[0] - 1, this.game_area_lt[1] + this.game_area_height, this.game_area_lt[0] + this.game_area_width + 1, this.game_area_lt[1] + this.game_area_height);
                    graphics.drawLine(this.game_area_lt[0] - 1, this.game_area_lt[1] + this.game_area_height - 1, this.game_area_lt[0] + this.game_area_width + 1, this.game_area_lt[1] + this.game_area_height - 1);
                    graphics.drawLine(this.game_area_lt[0], this.game_area_lt[1] - 1, this.game_area_lt[0], this.game_area_lt[1] + this.game_area_height);
                    graphics.drawLine(this.game_area_lt[0] - 1, this.game_area_lt[1], this.game_area_lt[0] - 1, this.game_area_lt[1] + this.game_area_height);
                }
            }
            graphics.setClip(this.next_item_lt[0], this.next_item_lt[1], this.cell_size * 4, this.cell_size * 4);
            this.paintClipRect(graphics);
            this.next_item.paint(graphics);
            if (this.orientation == 1) {
                graphics.setClip(this.game_area_lt[0] + 1, this.game_area_lt[1], this.game_area_width - 1, this.game_area_height);
            } else {
                graphics.setClip(this.game_area_lt[0] + 1, this.game_area_lt[1] + 1, this.game_area_width, this.game_area_height - 1);
            }
            this.paintClipRect(graphics);
            int n3 = 0;
            while (n3 < this.glass_map.length) {
                n2 = 0;
                while (n2 < this.glass_map[n3].length) {
                    if (this.glass_map[n3][n2] != 0) {
                        if (this.orientation == 1) {
                            TetrisItem.drawCell(graphics, this.game_area_lt[0] + 1 + this.cell_size * n3, this.game_area_lt[1] + this.cell_size * (n2 + 1) - this.start_pixel, this.cell_size, this.glass_map[n3][n2]);
                        } else {
                            TetrisItem.drawCell(graphics, this.game_area_lt[0] + this.game_area_width + 1 - this.cell_size * (n2 + 1) - this.start_pixel, this.game_area_lt[1] + this.game_area_height - this.cell_size * (n3 + 1), this.cell_size, this.glass_map[n3][n2]);
                        }
                    }
                    ++n2;
                }
                ++n3;
            }
            if (this.show_grid) {
                graphics.setColor(0x555555);
                if (this.orientation == 1) {
                    n2 = 0;
                    while (n2 < this.num_rows + 1) {
                        n = this.game_area_lt[1] + this.game_area_height - n2 * this.cell_size;
                        graphics.drawLine(this.game_area_lt[0], n, this.game_area_lt[0] + this.game_area_width, n);
                        ++n2;
                    }
                    n2 = 0;
                    while (n2 < this.num_cols + 1) {
                        n = this.game_area_lt[0] + this.game_area_width - n2 * this.cell_size;
                        graphics.drawLine(n, this.game_area_lt[1], n, this.game_area_lt[1] + this.game_area_height);
                        ++n2;
                    }
                } else {
                    n2 = 0;
                    while (n2 < this.num_cols + 1) {
                        n = this.game_area_lt[1] + this.game_area_height - n2 * this.cell_size;
                        graphics.drawLine(this.game_area_lt[0], n, this.game_area_lt[0] + this.game_area_width, n);
                        ++n2;
                    }
                    n2 = 0;
                    while (n2 < this.num_rows + 1) {
                        n = this.game_area_lt[0] + n2 * this.cell_size;
                        graphics.drawLine(n, this.game_area_lt[1], n, this.game_area_lt[1] + this.game_area_height);
                        ++n2;
                    }
                }
            }
            this.cur_item.paint(graphics);
            if (this.paused) {
                graphics.setClip(0, 0, this.width, this.height);
                if (this.midlet.isColor_phone()) {
                    graphics.setColor(204);
                } else {
                    graphics.setColor(1);
                }
                graphics.fillRoundRect(5, 5, this.width - 10, this.height - 10, 9, 9);
                graphics.setColor(0xFFFFFF);
                graphics.setFont(Font.getFont((int)0, (int)2, (int)16));
                if (this.orientation == 1) {
                    graphics.drawString(this.midlet.getI18n("game_paused"), this.width / 2, this.height / 2, 65);
                } else {
                    try {
                        Image image = Image.createImage((String)("/res/" + this.midlet.getLng() + "/pause.png"));
                        n = (this.width - image.getWidth()) / 2;
                        int n4 = (this.height - image.getHeight()) / 2;
                        graphics.drawImage(image, n, n4, 20);
                    }
                    catch (IOException iOException) {}
                }
            } else if (this.timer != null && !this.game_over) {
                if (this.new_scores.size() > 0) {
                    graphics.setColor(0xFF0000);
                    graphics.setFont(Font.getFont((int)32, (int)1, (int)0));
                    Enumeration enumeration = this.new_scores.elements();
                    while (enumeration.hasMoreElements()) {
                        NewScore newScore = (NewScore)enumeration.nextElement();
                        graphics.drawString(String.valueOf(newScore.getScore()), newScore.getX(), newScore.getY(), 20);
                    }
                }
                if (this.full_repaint) {
                    String string = String.valueOf(this.score);
                    if (this.orientation == 1) {
                        graphics.setClip(0, 0, this.width, this.height);
                        int n5 = this.cell_size * 4 + 4;
                        int n6 = this.game_area_lt[0];
                        n5 += TetrisView.drawString(graphics, string, n6, 0, n6 / 2, n5);
                        Font font = Font.getFont((int)0, (int)0, (int)8);
                        graphics.setFont(font);
                        graphics.drawString("L: " + (this.level + 1), n6 / 2, n5 += 4, 17);
                        n5 += font.getHeight();
                        int n7 = this.height - (n5 += 5);
                        int n8 = 0;
                        int n9 = 0;
                        if (n7 > 5 && this.high_scores > 0L) {
                            long l;
                            if (this.score < this.high_scores && this.score > 0L) {
                                l = 100000L / (this.high_scores * 1000L / this.score);
                                n9 = n7;
                                n8 = n9 * (int)l * 100 / 10000;
                            } else if (this.score > this.high_scores) {
                                l = 100000L / (this.score * 1000L / this.high_scores);
                                n8 = n7;
                                n9 = n8 * (int)l * 100 / 10000;
                            } else if (this.score == this.high_scores && this.score > 0L) {
                                n8 = n7;
                                n9 = n7;
                            }
                            if (n9 > 0) {
                                graphics.setColor(0xFF0000);
                                int n10 = (this.game_area_lt[0] - this.cell_size * 3) / 2;
                                graphics.fillRect(n10, this.height - n9, this.cell_size, n9);
                                graphics.setColor(65280);
                                graphics.fillRect(n10 + this.cell_size * 2, this.height - n8, this.cell_size, n8);
                                graphics.setColor(0x777777);
                                graphics.drawLine(n10 + this.cell_size, this.height - n9 - 1, n10 + this.cell_size, this.height);
                                graphics.drawLine(n10, this.height - 1, n10 + this.cell_size, this.height - 1);
                                graphics.drawLine(n10 + this.cell_size * 3, this.height - n8 - 1, n10 + this.cell_size * 3, this.height);
                                graphics.drawLine(n10 + this.cell_size * 2, this.height - 1, n10 + this.cell_size * 3, this.height - 1);
                            }
                        }
                    } else {
                        int n11;
                        int n12;
                        String string2 = String.valueOf(this.score);
                        int n13 = 0;
                        int n14 = this.game_area_lt[0] + this.game_area_width - this.cell_size * 4 - 4 - this.digit_images.getWidth();
                        int n15 = 0;
                        while (n15 < string2.length()) {
                            n12 = 0;
                            try {
                                n12 = Integer.parseInt(String.valueOf(string2.charAt(n15)));
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.err.println(numberFormatException.getClass().getName());
                            }
                            n13 += this.DIGIT_IMAGES_POS[n12 + 1] - this.DIGIT_IMAGES_POS[n12] + 2;
                            ++n15;
                        }
                        n12 = (this.game_area_lt[1] - n13) / 2;
                        n15 = 0;
                        while (n15 < string2.length()) {
                            int n16 = Integer.parseInt(String.valueOf(string2.charAt(n15)));
                            n11 = this.DIGIT_IMAGES_POS[n16 + 1] - this.DIGIT_IMAGES_POS[n16];
                            graphics.setClip(n14, n12, this.digit_images.getWidth(), n11);
                            this.paintClipRect(graphics);
                            graphics.drawImage(this.digit_images, n14, n12 - this.DIGIT_IMAGES_POS[n16], 20);
                            n12 += n11 + 2;
                            ++n15;
                        }
                        string = String.valueOf(this.level + 1);
                        int n17 = Integer.valueOf(String.valueOf(string.charAt(0)));
                        n11 = this.DIGIT_IMAGES_POS[n17 + 1] - this.DIGIT_IMAGES_POS[n17];
                        n14 -= this.digit_images.getWidth();
                        n12 = (this.game_area_lt[1] - (n11 + this.lvl_img.getHeight()) - 2) / 2;
                        graphics.setClip(n14 -= 4, n12, this.lvl_img.getWidth(), this.lvl_img.getHeight());
                        graphics.drawImage(this.lvl_img, n14, n12, 20);
                        n12 += this.lvl_img.getHeight();
                        graphics.setClip(n14, n12 += 2, this.digit_images.getWidth(), n11);
                        this.paintClipRect(graphics);
                        graphics.drawImage(this.digit_images, n14, n12 - this.DIGIT_IMAGES_POS[n17], 20);
                        graphics.setClip(0, 0, this.width, this.height);
                        n12 = (this.game_area_lt[1] - this.cell_size * 3) / 2;
                        int n18 = n14 - 5;
                        int n19 = 0;
                        int n20 = 0;
                        if (n18 > 5 && this.high_scores > 0L) {
                            if (this.score < this.high_scores && this.score > 0L) {
                                long l = 100000L / (this.high_scores * 1000L / this.score);
                                n20 = n18;
                                n19 = n20 * (int)l * 100 / 10000;
                            } else if (this.score > this.high_scores) {
                                long l = 100000L / (this.score * 1000L / this.high_scores);
                                n19 = n18;
                                n20 = n19 * (int)l * 100 / 10000;
                            } else if (this.score == this.high_scores && this.score > 0L) {
                                n19 = n18;
                                n20 = n18;
                            }
                            if (n20 > 0) {
                                graphics.setColor(0xFF0000);
                                graphics.fillRect(0, n12, n20, this.cell_size);
                                graphics.setColor(65280);
                                graphics.fillRect(0, n12 + this.cell_size * 2, n19, this.cell_size);
                                graphics.setColor(0x777777);
                                graphics.drawLine(0, n12 + this.cell_size, n20 - 2, n12 + this.cell_size);
                                graphics.drawLine(0, n12, 0, n12 + this.cell_size);
                                graphics.drawLine(0, n12 + this.cell_size * 3, n19 - 2, n12 + this.cell_size * 3);
                                graphics.drawLine(0, n12 + this.cell_size * 2, 0, n12 + this.cell_size * 3);
                            }
                        }
                    }
                }
            } else if (this.game_over) {
                graphics.setClip(0, 0, this.width, this.height);
                graphics.setColor(204);
                graphics.fillRoundRect(5, 5, this.width - 10, this.height - 10, 9, 9);
                graphics.setColor(0xFFFFFF);
                graphics.setFont(Font.getFont((int)0, (int)2, (int)16));
                if (this.orientation == 1) {
                    graphics.drawString(this.midlet.getI18n("game_over"), this.width / 2, this.height / 2, 65);
                } else {
                    try {
                        Image image = Image.createImage((String)("/res/" + this.midlet.getLng() + "/game_over.png"));
                        n = (this.width - image.getWidth()) / 2;
                        int n21 = (this.height - image.getHeight()) / 2;
                        graphics.drawImage(image, n, n21, 20);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            this.full_repaint = false;
        }
        if (this.offscreen != null) {
            graphics2.drawImage(this.offscreen, 0, 0, 20);
        }
    }

    protected void paintClipRect(Graphics graphics) {
        TetrisView.st_paintClipRect(graphics);
    }

    public void pauseGame() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.paused = true;
        this.full_repaint = true;
    }

    public void readKeysPreferences() {
        block3: {
            try {
                RecordStore recordStore = RecordStore.openRecordStore((String)RMS_KEY_PREFERENCES, (boolean)false);
                RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
                if (recordEnumeration.hasNextElement()) {
                    this.KEYS = recordEnumeration.nextRecord();
                    this.keys_settings_changed = true;
                    break block3;
                }
                this.setDefaultKeyPreferences();
            }
            catch (Exception exception) {
                this.setDefaultKeyPreferences();
            }
        }
    }

    public void saveGame(String string, boolean bl) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)RMS_SAVED_GAMES, (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(this.orientation);
            this.cur_item.saveToStream(dataOutputStream);
            this.next_item.saveToStream(dataOutputStream);
            dataOutputStream.writeLong(this.score);
            dataOutputStream.writeByte(this.level);
            int n = this.glass_map[0].length - 1;
            while (n > -1) {
                int n2 = 0;
                int n3 = 0;
                while (n3 < this.glass_map.length) {
                    if ((n2 += this.glass_map[n3][n]) > 0) break;
                    ++n3;
                }
                if (n2 == 0) break;
                int n4 = 0;
                while (n4 < this.glass_map.length) {
                    dataOutputStream.writeInt(this.glass_map[n4][n]);
                    ++n4;
                }
                --n;
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            SavedGame savedGame = (SavedGame)new SavedGames().getSaved_games_list().get(string);
            if (savedGame == null) {
                int n5 = recordStore.addRecord(byArray, 0, byArray.length);
                RecordStore recordStore2 = RecordStore.openRecordStore((String)"g", (boolean)true);
                ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream2);
                dataOutputStream2.writeUTF(string);
                dataOutputStream2.writeInt(n5);
                byte[] byArray2 = byteArrayOutputStream2.toByteArray();
                recordStore2.addRecord(byArray2, 0, byArray2.length);
                recordStore2.closeRecordStore();
            } else {
                recordStore.setRecord(savedGame.id, byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            this.midlet.getDisplay().setCurrent((Displayable)this);
            this.continueGame();
        }
    }

    public void saveKeysPreferences() {
        this.keys_settings_changed = true;
        try {
            try {
                RecordStore.deleteRecordStore((String)RMS_KEY_PREFERENCES);
            }
            catch (Exception exception) {
                // empty catch block
            }
            RecordStore recordStore = RecordStore.openRecordStore((String)RMS_KEY_PREFERENCES, (boolean)true);
            recordStore.addRecord(this.KEYS, 0, this.KEYS.length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {}
    }

    public void setDefaultKeyPreferences() {
        this.keys_settings_changed = false;
        if (this.KEYS == null) {
            this.KEYS = new byte[5];
        }
        if (this.orientation == 1) {
            this.KEYS[0] = 49;
            this.KEYS[1] = 51;
            this.KEYS[2] = 48;
            this.KEYS[3] = 52;
            this.KEYS[4] = 42;
        } else {
            this.KEYS[0] = 49;
            this.KEYS[1] = 55;
            this.KEYS[2] = 48;
            this.KEYS[3] = 52;
            this.KEYS[4] = 42;
        }
    }

    public void setDefaultOptions() {
        this.orientation = this.width > this.height ? (byte)2 : (byte)1;
        this.setInitial_rate(600);
        this.setMinimum_rate(100);
        this.setNext_level_delta(50);
        this.setNext_level_devider(100);
        this.prohibition_elements = 32640;
        this.usenonstdel_on_nextlvl = true;
        this.show_grid = true;
        this.show_animation_on_removing_line = true;
    }

    public void setInitial_rate(int n) {
        this.initial_rate = n;
    }

    public synchronized void setLevel(byte by) {
        this.level = by;
    }

    public void setMinimum_rate(int n) {
        this.minimum_rate = n;
    }

    public void setNext_level_delta(int n) {
        this.next_level_delta = n;
    }

    public void setNext_level_devider(int n) {
        this.next_level_devider = n;
    }

    public void setOrientation(byte by) {
        this.orientation = by;
    }

    public void setProhibition_elements(int n) {
        this.prohibition_elements = n;
    }

    public void setShow_animation_on_removing_line(boolean bl) {
        this.show_animation_on_removing_line = bl;
    }

    public void setShow_grid(boolean bl) {
        this.show_grid = bl;
    }

    public void setUsenonstdel_on_nextlvl(boolean bl) {
        this.usenonstdel_on_nextlvl = bl;
    }

    protected void showNotify() {
        super.showNotify();
        if (this.paused) {
            this.paused = false;
            this.continueGame();
        }
        this.full_repaint = true;
        this.repaint();
    }

    public static void st_paintClipRect(Graphics graphics) {
        int n = graphics.getColor();
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(graphics.getClipX(), graphics.getClipY(), graphics.getClipWidth(), graphics.getClipHeight());
        graphics.setColor(n);
    }

    public synchronized byte stepElement() {
        byte by = this.cur_item.stepElement();
        block2 : switch (by) {
            case 2: {
                TetrisItem tetrisItem = this.next_item;
                this.next_item = this.cur_item;
                this.next_item.randomize();
                this.next_item.setTop(this.next_item_lt[0], this.next_item_lt[1]);
                this.cur_item = tetrisItem;
                byte[] byArray = this.cur_item.getMap();
                int n = byArray.length - 1;
                while (n > -1) {
                    if (byArray[n] != 0) break;
                    --n;
                }
                this.cur_item.setCell(Utils.getRandomNumber(this.num_cols - this.cur_item.getMap().length - 1), -n);
                if (this.orientation == 1) {
                    this.cur_item.setTop(this.game_area_lt[0] + 1, this.game_area_lt[1] + 1 - this.start_pixel);
                } else {
                    this.cur_item.setTop(this.game_area_lt[0], this.game_area_lt[1] + 2);
                }
                int n2 = 0;
                int n3 = 0;
                int n4 = -1;
                int n5 = this.glass_map[0].length - 1;
                while (n5 >= 0) {
                    int n6;
                    int n7;
                    int n8;
                    int n9 = 0;
                    boolean bl = false;
                    int n10 = 0;
                    while (n10 < this.glass_map.length) {
                        if (this.glass_map[n10][n5] == 0) {
                            bl = true;
                        }
                        n9 += this.glass_map[n10][n5];
                        ++n10;
                    }
                    if (!bl) {
                        if (n4 == n5) {
                            n2 = n2 > 0 ? (n2 *= 2) : n3 * 2;
                        } else {
                            n3 += 5;
                        }
                        if (this.show_animation_on_removing_line) {
                            this.timer.cancel();
                            this.repaint();
                            this.serviceRepaints();
                            n8 = this.glass_map.length;
                            ++this.anim_style;
                            if (this.anim_style > 2) {
                                this.anim_style = 0;
                            }
                            n7 = 1;
                            switch (this.anim_style) {
                                case 0: {
                                    n6 = 0;
                                    break;
                                }
                                case 1: {
                                    n6 = n8;
                                    break;
                                }
                                default: {
                                    n6 = n8 / 2;
                                }
                            }
                            if (this.anim_style < 2) {
                                while (n8 > 0) {
                                    if (n6 > -1 && n6 < this.glass_map.length) {
                                        this.glass_map[n6][n5] = 0;
                                    }
                                    this.repaint();
                                    this.serviceRepaints();
                                    try {
                                        Thread.sleep(25L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    if (this.anim_style == 0) {
                                        ++n6;
                                        --n8;
                                        continue;
                                    }
                                    --n6;
                                    --n8;
                                }
                            } else {
                                int n11 = n6;
                                while (n6 > -1 || n11 < this.glass_map.length) {
                                    if (n6 > -1) {
                                        this.glass_map[n6][n5] = 0;
                                    }
                                    if (n11 < this.glass_map.length) {
                                        this.glass_map[n11][n5] = 0;
                                    }
                                    this.repaint();
                                    this.serviceRepaints();
                                    try {
                                        Thread.sleep(50L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    --n6;
                                    ++n11;
                                }
                            }
                            this.timer = null;
                            this.continueGame();
                        }
                        n8 = 0;
                        while (n8 < this.glass_map.length) {
                            System.arraycopy(this.glass_map[n8], 0, this.glass_map[n8], 1, n5);
                            ++n8;
                        }
                        n4 = n5++;
                    } else {
                        if (n2 > 0) {
                            n3 += n2;
                            n2 = 0;
                        }
                        n4 = -1;
                        if (n3 > 0) {
                            this.full_repaint = true;
                            if (this.orientation == 1) {
                                this.new_scores.addElement(new NewScore(this.game_area_lt[0] + this.cell_size * (this.num_cols / 2), this.game_area_lt[1] + this.cell_size * n5, n3));
                            } else {
                                this.new_scores.addElement(new NewScore(this.game_area_lt[0] + this.cell_size * (this.num_rows - n5), this.game_area_lt[1] + this.cell_size * (this.num_cols / 2), n3));
                            }
                            this.score += (long)n3;
                            n3 = 0;
                            if (this.score >= (long)this.next_level_devider && this.score % (long)this.next_level_devider == 0L) {
                                this.pauseGame();
                                this.level = (byte)(this.level + 1);
                                this.setLevel(this.level);
                                this.rate -= this.next_level_delta;
                                if (this.rate < this.minimum_rate) {
                                    this.rate = this.minimum_rate;
                                }
                                if (this.usenonstdel_on_nextlvl && this.bck_prohibition_elements != 0) {
                                    if (this.prohibition_elements == 0) {
                                        n8 = Utils.getFirstEnabledBit(this.bck_prohibition_elements, 0);
                                        n6 = 1;
                                        this.prohibition_elements |= (n6 <<= n8);
                                    } else {
                                        n8 = Utils.getLastEnabledBit(this.prohibition_elements);
                                        n6 = Utils.getFirstEnabledBit(this.bck_prohibition_elements, n8 + 1);
                                        n7 = 1;
                                        this.prohibition_elements |= (n7 <<= n6);
                                    }
                                }
                                this.continueGame();
                            }
                        }
                    }
                    if (n9 == 0) break block2;
                    --n5;
                }
                break;
            }
            case 3: {
                this.endGame();
                this.game_over = true;
            }
        }
        return by;
    }
}

