/*
 * Decompiled with CFR 0.152.
 */
package Puzzle3D;

import Puzzle3D.Polyhedron;
import Puzzle3D.PuzzleMidlet;
import Puzzle3D.PuzzleState;
import Puzzle3D.Savable;
import Puzzle3D.Stopwatch;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public abstract class PuzzleCanvas
extends Canvas
implements CommandListener,
Runnable,
Savable {
    public PuzzleState state;
    public Stopwatch stopwatch;
    public static final int PH_OK = 0;
    public static final int PH_NOGOOD = 1;
    public static final int PH_NOK_SERIES60 = 2;
    public static final int PH_MOT_I95CL = 3;
    public boolean fullVersion = false;
    protected Image solvedPic;
    protected boolean paintSolvedOnly = false;
    protected boolean showSolved = false;
    protected Image choosePic;
    protected boolean paintChooseOnly = false;
    protected Polyhedron polyhedron;
    protected Image offscreenImage = Image.createImage((int)this.getWidth(), (int)this.getHeight());
    protected Graphics offscreenGraphics;
    protected int lastPuzzle;
    protected byte spins;
    protected final int TRIALSPINS;
    protected boolean animating = false;
    protected boolean clockOnscreen;
    protected boolean paintClockOnly = false;
    protected boolean drawBackgroundOnly = false;
    protected boolean showChoose;
    protected int currentHallOfFame = 0;
    protected PuzzleMidlet midlet;
    protected int trialLevel;
    protected Display display;
    protected boolean twisted = false;
    protected int twistAxis;
    protected final int M_ROTATE;
    protected final int M_TWIST;
    protected final int M_SOLVED;
    protected final int M_DANCE;
    protected int animateType = 1;
    protected int animateStepsLeft = 0;
    protected long lastStepTime = System.currentTimeMillis();
    protected final long MIN_TWIST_TIME;
    private boolean polyhedronNeedsDrawing = true;

    public int phoneType() {
        int height;
        int width = this.getWidth();
        if (width == 176 & (height = this.getHeight()) == 144) {
            return 2;
        }
        if (width == 120 & height == 160) {
            return 3;
        }
        return 0;
    }

    public boolean animating() {
        return this.animating;
    }

    public void saveMe(DataOutputStream outputStream) throws IOException {
        this.polyhedron.saveMe(outputStream);
        outputStream.writeByte(this.spins);
        outputStream.writeInt(this.lastPuzzle);
        this.stopwatch.saveMe(outputStream);
    }

    public void loadMe(DataInputStream inputStream) throws EOFException, IOException {
        this.polyhedron.loadMe(inputStream);
        this.spins = inputStream.readByte();
        this.lastPuzzle = inputStream.readInt();
        this.stopwatch.loadMe(inputStream);
    }

    public void initMe() {
        this.polyhedron.initMe();
        this.spins = 0;
        this.lastPuzzle = 0;
        this.stopwatch.initMe();
    }

    public void showAbout() {
        PuzzleMidlet.setScreen((Displayable)PuzzleMidlet.aboutAlert);
    }

    protected void sleep(int millisecs) {
        Thread t = Thread.currentThread();
        try {
            Thread.sleep(millisecs);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void gotoAskNameScreen() {
        try {
            if (PuzzleMidlet.fameForm.placed(this.currentHallOfFame, this.stopwatch.elapsed())) {
                PuzzleMidlet.nameInputForm.setDefaultName();
                PuzzleMidlet.setScreen((Displayable)PuzzleMidlet.nameInputForm);
            }
        }
        catch (Exception ioe) {
            System.out.println(ioe);
            ioe.printStackTrace();
        }
    }

    protected boolean appExpired() {
        return false;
    }

    protected void incrementSpins() {
        if (this.spins < 100) {
            this.spins = (byte)(this.spins + 1);
        }
    }

    protected void nPuzzle(int n) {
        if (n > this.trialLevel & !this.fullVersion) {
            PuzzleMidlet.setScreen((Displayable)PuzzleMidlet.freeVersionAlert);
            return;
        }
        this.showChoose = false;
        this.midlet.midletState = 0;
        this.drawBackgroundOnly = true;
        this.paintMe();
        this.polyhedron.nPuzzle(n);
        this.renderPolyhedronOffscreen();
        System.gc();
        this.paintMe();
        this.lastPuzzle = n;
        this.currentHallOfFame = n - 2;
        this.midlet.midletState = 1;
        this.stopwatch.start();
    }

    private void signalIfSolved() {
        if (!this.polyhedron.jumbled()) {
            if (this.midlet.midletState == 1) {
                this.paintSolvedOnly = true;
                this.paintMe();
                AlertType.CONFIRMATION.playSound(this.display);
                this.midlet.midletState = 0;
                this.stopwatch.pause();
                this.solvedMove();
            } else {
                this.showChoose = true;
            }
        }
    }

    private void stepDelay() {
        long minTwistStepTime = 300L / (long)this.polyhedron.TWISTSTEPS;
        long interval = System.currentTimeMillis() - this.lastStepTime;
        long timeLeft = minTwistStepTime - interval;
        if (timeLeft > 0L) {
            this.sleep((int)timeLeft);
        }
        this.lastStepTime = System.currentTimeMillis();
    }

    private void oneTwistOrRotateMove() {
        if (this.animateStepsLeft > 2) {
            this.stepDelay();
            this.spinOneStep(this.twistAxis, true);
            this.renderPolyhedronOffscreen();
            this.repaintSerially();
            --this.animateStepsLeft;
        } else if (this.animateStepsLeft > 1) {
            this.stepDelay();
            this.moveTheSegments();
            boolean saveTwisted = this.twisted;
            this.twisted = false;
            this.polyhedron.setTwisted(false);
            this.renderPolyhedronOffscreen();
            this.twisted = saveTwisted;
            this.repaintSerially();
            --this.animateStepsLeft;
        } else {
            --this.animateStepsLeft;
            this.animating = false;
            if (this.twisted) {
                this.twisted = false;
                this.signalIfSolved();
            }
        }
    }

    private void oneDanceMove() {
        if (this.animateStepsLeft > 1) {
            this.spinOneStep(this.twistAxis, true);
            this.renderPolyhedronOffscreen();
            this.showSolved = true;
            this.repaintSerially();
            --this.animateStepsLeft;
        } else {
            --this.animateStepsLeft;
            this.animating = false;
            this.showSolved = false;
            this.polyhedron.straighten();
            this.renderPolyhedronOffscreen();
            System.gc();
            this.gotoAskNameScreen();
        }
    }

    private void oneSolvedMove() {
        if (this.animateStepsLeft > 1) {
            this.showSolved = true;
            this.repaintSerially();
            --this.animateStepsLeft;
        } else {
            this.sleep(1000);
            --this.animateStepsLeft;
            this.animating = false;
            this.showSolved = false;
            this.showChoose = true;
            this.gotoAskNameScreen();
        }
    }

    private void oneMove() {
        switch (this.animateType) {
            case 1: 
            case 2: {
                this.oneTwistOrRotateMove();
                break;
            }
            case 3: {
                this.oneSolvedMove();
                break;
            }
            case 4: {
                this.oneDanceMove();
            }
        }
    }

    public void run() {
        if (this.animateStepsLeft > 0) {
            this.oneMove();
        }
    }

    private void startAnimation(int moveType) {
        this.animating = true;
        this.animateType = moveType;
        switch (this.animateType) {
            case 1: {
                this.twisted = false;
                this.animateStepsLeft = this.polyhedron.TWISTSTEPS + 1;
                break;
            }
            case 2: {
                this.twisted = true;
                this.polyhedron.setTwisted(true);
                this.animateStepsLeft = this.polyhedron.TWISTSTEPS + 1;
                break;
            }
            case 3: {
                this.twisted = false;
                this.animateStepsLeft = 2;
            }
        }
        this.oneMove();
    }

    private void solvedMove() {
        this.twistAxis = 1;
        this.startAnimation(3);
    }

    protected void doTheMove(int axis, boolean twistMove) {
        this.incrementSpins();
        this.twistAxis = axis;
        if (twistMove) {
            this.startAnimation(2);
        } else {
            this.startAnimation(1);
        }
    }

    public void paint(Graphics g) {
        if (this.drawBackgroundOnly) {
            this.polyhedron.paintBackground(g);
            this.drawBackgroundOnly = false;
            return;
        }
        if (this.polyhedronNeedsDrawing) {
            this.paintClockOnly = false;
            this.polyhedronNeedsDrawing = false;
        }
        if (this.paintClockOnly) {
            this.paintClock(g);
            this.paintClockOnly = false;
            return;
        }
        if (this.paintSolvedOnly) {
            g.drawImage(this.solvedPic, this.polyhedron.XORIGIN, this.polyhedron.YORIGIN, 3);
            this.paintSolvedOnly = false;
            return;
        }
        if (this.paintChooseOnly) {
            this.drawChoose(g);
            this.paintChooseOnly = false;
            return;
        }
        g.drawImage(this.offscreenImage, 0, 0, 20);
        this.paintClock(g);
        if (this.showChoose) {
            this.drawChoose(g);
        }
        if (this.showSolved) {
            g.drawImage(this.solvedPic, this.polyhedron.XORIGIN, this.polyhedron.YORIGIN, 3);
        }
    }

    void repaintSerially() {
        this.repaint();
        this.display.callSerially((Runnable)this);
    }

    private void spinOneStep(int axis, boolean clockwise) {
        this.polyhedron.setSpinVector(axis, clockwise);
        this.polyhedron.doSpin();
    }

    private void moveTheSegments() {
        this.polyhedron.straighten();
        if (this.twisted) {
            this.polyhedron.twistSegments();
        } else {
            this.polyhedron.rotateSegments();
        }
    }

    protected void showNotify() {
        if (this.midlet.midletState == 1) {
            this.stopwatch.unpause();
        }
        if (!this.polyhedron.jumbled()) {
            this.showChoose = true;
        }
        this.polyhedronNeedsDrawing = true;
    }

    protected void hideNotify() {
        if (this.midlet.midletState == 1) {
            this.stopwatch.pause();
        }
        this.paintClockOnly = false;
    }

    protected void drawChoose(Graphics g) {
        g.drawImage(this.choosePic, this.polyhedron.XORIGIN, this.polyhedron.YORIGIN, 3);
    }

    protected void renderPolyhedronOffscreen() {
        this.polyhedron.paintBackground(this.offscreenGraphics);
        this.polyhedron.paint(this.offscreenGraphics);
    }

    protected void resetPolyhedron() {
        this.midlet.midletState = 0;
        this.paintClockOnly = false;
        this.showChoose = false;
        this.drawBackgroundOnly = true;
        this.paintMe();
        this.polyhedron.unjumble();
        this.renderPolyhedronOffscreen();
        this.paintMe();
    }

    protected void paintMe() {
        this.repaint();
        this.serviceRepaints();
    }

    public void updateClock() {
        if (this.stopwatch.elapsed() < 6000000L) {
            this.clockOnscreen = true;
            this.paintClockOnly = true;
            this.paintMe();
        } else if (this.clockOnscreen) {
            this.clockOnscreen = false;
            this.paintMe();
        }
    }

    protected void paintClock(Graphics g) {
        if (this.midlet.midletState != 1) {
            return;
        }
        this.stopwatch.paintTheClock(g);
    }

    protected void checkPuzzle() {
        if (this.lastPuzzle == 0) {
            this.lastPuzzle = 2;
            PuzzleMidlet.setScreen((Displayable)PuzzleMidlet.firstPuzzleAlert);
        }
    }

    protected void loadImages() {
        try {
            this.solvedPic = Image.createImage((String)"/PyramidCode/res/solved.png");
        }
        catch (Exception e) {
            System.out.println("Exception reading solved image: " + e);
        }
        try {
            this.choosePic = Image.createImage((String)"/PyramidCode/res/choose.png");
        }
        catch (Exception e) {
            System.out.println("Exception reading choose image: " + e);
        }
        this.offscreenGraphics = this.offscreenImage.getGraphics();
    }

    protected void initPuzzle() {
        this.state.loadAllClassStates(this.midlet, this, PuzzleMidlet.fameForm);
        if (this.midlet.midletState == 1) {
            this.stopwatch.unpause();
        }
        this.renderPolyhedronOffscreen();
        if (!this.polyhedron.jumbled()) {
            this.showChoose = true;
        }
    }

    public PuzzleCanvas(PuzzleMidlet midlet, int clockX, int clockY) {
        this.TRIALSPINS = 100;
        this.M_ROTATE = 1;
        this.M_TWIST = 2;
        this.M_SOLVED = 3;
        this.M_DANCE = 4;
        this.MIN_TWIST_TIME = 300L;
        this.stopwatch = new Stopwatch(clockX, clockY);
        this.midlet = midlet;
        this.display = Display.getDisplay((MIDlet)midlet);
        this.loadImages();
    }

    public abstract void commandAction(Command var1, Displayable var2);

    static {
        PH_OK = 0;
        PH_NOGOOD = 1;
        PH_NOK_SERIES60 = 2;
        PH_MOT_I95CL = 3;
    }
}

