/*
 * Decompiled with CFR 0.152.
 */
package whl;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import whl.Score;
import whl.ScoreListListener;

public abstract class ScoreList {
    private static int HEADERHIGHT = 14;
    private static int FONTHEIGHT = 12;
    private static int c1r = 200;
    private static int c1g = 200;
    private static int c1b = 200;
    private static int c2r = 140;
    private static int c2g = 140;
    private static int c2b = 140;
    private boolean toggle = true;
    public static final int ERROR = 2;
    public static final int LOADGLOBAL_OK = 3;
    public static final int LOADLOCAL_OK = 4;
    public static final int SYNC_OK = 5;
    public static final int TASK_READ = 1;
    public static final int TASK_SYNC = 2;
    public Thread runner;
    public boolean running = false;
    public int threadType;
    private static final int maxSize = 10;
    public Vector theList = new Vector();
    private ScoreListListener listener;
    public Gauge gauge;

    public void setGauge(Gauge ga) {
        this.gauge = ga;
    }

    public void setList(Vector v) {
        this.theList = v;
    }

    public Vector getList() {
        return this.theList;
    }

    public int getMaxSize() {
        return 10;
    }

    public int paint(Graphics g, int index, String name, boolean color) {
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, g.getClipWidth(), g.getClipHeight());
        if (color) {
            g.setColor(0, 0, 255);
            g.fillRect(0, 0, g.getClipWidth(), HEADERHIGHT);
            g.setColor(255, 255, 255);
        } else {
            g.setColor(0, 0, 0);
        }
        g.drawString(name, g.getClipWidth() / 2, 0, 17);
        g.setFont(Font.getFont((int)0, (int)0, (int)8));
        int yPos = HEADERHIGHT + 1;
        for (int i = index; i < this.theList.size(); ++i) {
            Score tmpScore = (Score)this.theList.elementAt(i);
            if (color) {
                if (this.toggle) {
                    g.setColor(c1r, c1g, c1b);
                } else {
                    g.setColor(c2r, c2g, c2b);
                }
                this.toggle = !this.toggle;
                g.fillRect(1, yPos, g.getClipWidth() - FONTHEIGHT, FONTHEIGHT);
            }
            g.setColor(0, 0, 0);
            if (tmpScore.isSynch()) {
                g.drawString(String.valueOf(String.valueOf(new StringBuffer("s").append(i + 1).append(": ").append(tmpScore.getValue()))), 1, yPos + 1, 20);
            } else {
                g.drawString(String.valueOf(String.valueOf(new StringBuffer(" ").append(i + 1).append(": ").append(tmpScore.getValue()))), 1, yPos + 1, 20);
            }
            g.drawString(tmpScore.getName(), g.getClipWidth() / 2, yPos + 1, 20);
            if ((yPos += FONTHEIGHT) >= g.getClipHeight() - FONTHEIGHT) break;
        }
        return (yPos - FONTHEIGHT) / FONTHEIGHT;
    }

    public void sort() {
        for (int i = 0; i <= this.theList.size(); ++i) {
            if (this.gauge != null) {
                this.gauge.setValue(i * 100 / this.theList.size());
            }
            for (int j = 0; j < this.theList.size() - 1 && (this.runner == null || this.running); ++j) {
                Score tmpScore1 = (Score)this.theList.elementAt(j);
                Score tmpScore2 = (Score)this.theList.elementAt(j + 1);
                if (tmpScore2.getValue() <= tmpScore1.getValue() && (tmpScore2.getValue() != tmpScore1.getValue() || tmpScore2.getId() <= tmpScore1.getId())) continue;
                this.theList.setElementAt(tmpScore2, j);
                this.theList.setElementAt(tmpScore1, j + 1);
            }
            if (this.runner != null && !this.running) break;
        }
    }

    public void setListener(ScoreListListener sl) {
        this.listener = sl;
    }

    public ScoreListListener getListener() {
        return this.listener;
    }

    public void start(int type) {
        if (this.runner == null) {
            this.runner = new Thread((Runnable)((Object)this.getScoreList()));
            this.runner.start();
            this.threadType = type;
            this.running = true;
        }
    }

    public void stop() {
        if (this.runner != null) {
            this.runner = null;
            this.running = false;
        }
    }

    public abstract ScoreList getScoreList();

    static {
        ERROR = 2;
        LOADGLOBAL_OK = 3;
        LOADLOCAL_OK = 4;
        SYNC_OK = 5;
        TASK_READ = 1;
        TASK_SYNC = 2;
        maxSize = 10;
    }
}

