/*
 * Decompiled with CFR 0.152.
 */
package gpong;

import gpong.Config;
import gpong.PongCanvas;
import javax.microedition.lcdui.Graphics;

public class Ball {
    public int lives;
    private static int r = 5;
    public static int step = Config.BALLSPEED;
    private int x;
    private int y;
    private int oldx;
    private int oldy;
    private int dx = step;
    private int dy = -step;
    private int width;
    private int height;
    private int xCenter;
    private int yCenter;
    private PongCanvas pCanvas;

    public Ball(PongCanvas pc, int l) {
        this.pCanvas = pc;
        this.lives = l;
        r = Config.RADIUS;
        this.width = Config.WIDTH - Config.PANELWIDTH - r;
        this.height = Config.HEIGHT - r;
        this.xCenter = pc.centerX;
        this.yCenter = pc.centerY;
        this.oldx = this.x = pc.player.getX() + pc.playerWidth / 2;
        this.oldy = this.y = pc.player.getY() - r;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getR() {
        return r;
    }

    public void fire() {
        this.lives = 0;
    }

    public void setDy(int theDy) {
        this.dy = theDy;
    }

    public void setDx(int theDx) {
        this.dx = theDx;
    }

    protected void paint(Graphics g) {
        if (this.lives != 0) {
            this.x = this.pCanvas.player.getX() + this.pCanvas.playerWidth / 2 - r / 2;
            if (this.lives < 90) {
                g.setColor(255, 255, 255);
                g.fillRect(this.x, this.y - r - 10, 10, 10);
                g.setColor(0, 0, 0);
                g.drawString(Integer.toString(this.lives / 10), this.x + 5, this.y - r - 1, 65);
            }
            --this.lives;
        }
        g.setColor(255, 0, 0);
        g.fillRoundRect(this.x, this.y, r, r, 2 * r, 2 * r);
        g.setColor(64, 64, 64);
        g.drawRoundRect(this.x, this.y, r, r, 2 * r, 2 * r);
        if (this.lives == 0) {
            this.move();
        }
    }

    public boolean isOutOfRange() {
        return this.y + 2 * r > this.pCanvas.player.getY() + Config.PLAYERHIGHT + r;
    }

    public void move() {
        this.oldx = this.x;
        this.oldy = this.y;
        this.x += this.dx;
        this.y += this.dy;
        if (this.x < 0) {
            this.x = 0;
            this.dx = step;
        }
        if (this.y < 0) {
            this.y = 0;
            this.dy = step;
        }
        if (this.x > this.width) {
            this.x = this.width;
            this.dx = -step;
        }
    }
}

