/*
 * Decompiled with CFR 0.152.
 */
package whl;

import java.util.Vector;
import whl.DBManager;
import whl.GlobalScoreList;
import whl.Score;
import whl.ScoreList;
import whl.ScoreListListener;
import whl.WorldHighscoreListException;

public class LocalScoreList
extends ScoreList
implements Runnable {
    public static final int NORANKINGID = 10;
    private GlobalScoreList globalList;
    private boolean registered;
    private DBManager dbm = new DBManager("locale");

    public void read() {
        this.start(1);
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.runner == thisThread) {
            if (this.threadType == 1) {
                this.readThread();
                continue;
            }
            this.syncThread();
        }
    }

    private void readThread() {
        block2: {
            Vector idList = new Vector();
            Vector stringVector = this.dbm.read(this.gauge, this.running);
            idList = this.dbm.getIdVector();
            this.gauge.setLabel("Parsing");
            for (int i = 0; i < stringVector.size() && this.running; ++i) {
                Integer id = (Integer)idList.elementAt(i);
                this.add((String)stringVector.elementAt(i), id);
                this.gauge.setValue(i * 100 / stringVector.size());
            }
            if (stringVector.size() != 0) {
                this.gauge.setLabel("sort");
                this.sort();
            }
            this.stop();
            ScoreListListener sll = super.getListener();
            if (sll == null) break block2;
            sll.listFinished(this, 4, "OK!");
        }
    }

    public void add(String s, int id) {
        Score score = new Score(s);
        score.setId(id);
        this.theList.addElement(score);
    }

    public int add(Score s) {
        int ranking = this.getRanking(s);
        if (ranking != 10) {
            this.theList.addElement(s);
            super.sort();
            if (this.theList.size() > this.getMaxSize()) {
                Score tmpScore = (Score)this.theList.lastElement();
                this.dbm.set(tmpScore.getId(), s.toString());
                s.setId(tmpScore.getId());
                this.theList.removeElementAt(this.theList.size() - 1);
            } else {
                int id = this.dbm.append(s.toString());
                s.setId(id);
            }
        }
        return ranking;
    }

    public int getRanking(Score s) {
        if (s.getValue() == (long)0) {
            return 10;
        }
        int i = 0;
        if (this.theList.size() == 0) {
            return 1;
        }
        for (i = 0; i < this.theList.size(); ++i) {
            Score tmpScore = (Score)this.theList.elementAt(i);
            if (s.getValue() <= tmpScore.getValue()) continue;
            return i + 1;
        }
        if (this.theList.size() + 1 < this.getMaxSize()) {
            return i + 1;
        }
        return 10;
    }

    private void set(Score s) {
        this.dbm.set(s.getId(), s.toString());
    }

    public void sync(GlobalScoreList theGlobalList, boolean reg) {
        this.globalList = theGlobalList;
        this.registered = reg;
        this.start(2);
    }

    private synchronized void syncThread() {
        block9: {
            String msg = null;
            int bestRanking = 9999;
            int ranking = 0;
            this.gauge.setLabel("synch");
            this.gauge.setValue(0);
            try {
                for (int i = 0; i < this.theList.size() && this.running; ++i) {
                    this.gauge.setValue(i * 100 / this.theList.size());
                    Score tmpScore = (Score)this.theList.elementAt(i);
                    if (tmpScore.isSynch()) continue;
                    String servermsg = this.globalList.add(tmpScore, this.registered);
                    if (servermsg.length() <= 4) {
                        ranking = Integer.parseInt(servermsg = servermsg.substring(0, servermsg.indexOf("\n")));
                        if (ranking != 10 && ranking < bestRanking) {
                            bestRanking = ranking;
                        }
                        tmpScore.setSynch();
                        this.set(tmpScore);
                        continue;
                    }
                    msg = servermsg;
                }
                if (msg == null && bestRanking == 9999) {
                    msg = "No Ranking!";
                } else if (msg == null && bestRanking != 9999) {
                    msg = String.valueOf(String.valueOf(new StringBuffer("Best ranking is ").append(bestRanking + 1).append("!")));
                }
                ScoreListListener sll = super.getListener();
                if (sll != null) {
                    sll.listFinished(this, 5, msg);
                }
            }
            catch (WorldHighscoreListException e) {
                e.printStackTrace();
                if (!this.running) break block9;
                msg = "Score Server not found !";
                ScoreListListener sll = super.getListener();
                if (sll == null) break block9;
                sll.listFinished(this, 2, msg);
            }
        }
        this.stop();
    }

    public ScoreList getScoreList() {
        return this;
    }

    static {
        NORANKINGID = 10;
    }
}

