/*
 * Decompiled with CFR 0.152.
 */
import com.siemens.mp.color_game.GameCanvas;
import com.siemens.mp.color_game.Sprite;
import com.siemens.mp.color_game.TiledLayer;
import com.siemens.mp.game.Melody;
import com.siemens.mp.game.MelodyComposer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

class iceCanvas
extends GameCanvas
implements Runnable {
    private int gameMode = 0;
    private int counter;
    private int mazeCount;
    private int levGround;
    private int lastKey;
    private int oldKey;
    private final iceplus owner;
    Thread runner;
    private Random rnd = new Random();
    private Font f;
    private long modeTime;
    private byte[] spriteH = new byte[]{19, 21, 20, 19, 20, 20, 19, 20, 21, 20, 19, 21, 20, 19, 16, 18, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 19, 18, 16, 14, 12, 12, 17, 18, 19, 18, 10, 10, 10, 10, 8, 7};
    private final byte[] spriteEffH = new byte[]{20, 22, 21, 20, 21, 21, 20, 21, 22, 21, 20, 22, 21, 20, 16, 18, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 19, 17, 15, 13, 13, 17, 18, 19, 18, 16, 16, 16, 16, 8, 7};
    private final byte[] shadowX = new byte[]{4, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 5, 5, 5, 5, 0, 0, 0, 5, 5, 5, 5, 4, 4, 4, 4, 4, 3, 2, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final byte[] shadowType = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0};
    private int[] map = new int[144];
    private byte[] ground = new byte[288];
    private byte[] shadBytes = new byte[]{0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0};
    private byte[] roundShadow = new byte[128];
    private byte[] squareShadow = new byte[128];
    private Image logo;
    private TiledLayer layer1;
    private TiledLayer layer2;
    private TiledLayer layer3;
    private byte[] tiles1 = new byte[128];
    private byte[] tiles2 = new byte[1408];
    private byte[] tiles3 = new byte[1344];
    private int[] decoLayer = new int[360];
    private Sprite[] topSprites;
    private Sprite[] botSprites;
    private Sprite[] shadowSprites;
    private int score;
    private int[] highscores = new int[8];
    private int nextMode;
    private int startLevel;
    private int maxLevel;
    private int soundOn = 1;
    private int introCount;
    private int coins;
    private int lives;
    private int level;
    private int highRow;
    private int highCol;
    private int offsX;
    private int clipX;
    private int clipW;
    private int offsY;
    private int clipY;
    private int clipH;
    private iceObject[] objs = new iceObject[10];
    private int[] sortY = new int[10];
    private int[] sortIX = new int[10];
    private int sortN;
    private int[] enemies = new int[4];
    private byte[] levFl1 = new byte[]{1, 2, 2, 3, 3, 1, 1, 2, 2, 4, 4, 1, 1, 2, 2, 0, 0, 1, 1, 0};
    private byte[] levFl2 = new byte[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 2, 2, 2, 2, 3, 3, 3, 3, 4};
    private byte[] levIce = new byte[]{12, 12, 13, 13, 14, 14, 16, 16, 12, 12, 12, 17, 17, 12, 12, 18, 18, 12, 12, 12};
    private byte[] levRock = new byte[]{7, 7, 7, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 6, 6};
    private byte[] cyclic = new byte[]{0, 1, 2, 1};
    private byte[] cyclic2 = new byte[]{0, 1, 2, 3, 2, 1};
    private byte[] pStepX = new byte[]{3, 2, 3, 3, 2, 3};
    private byte[] pStepY = new byte[]{2, 2, 2, 2};
    private byte[] iStepX = new byte[]{5, 5, 6};
    private byte[] iStepY = new byte[]{4, 4};
    private byte[] fStepX = new byte[]{2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 1};
    private byte[] fStepY = new byte[]{1, 1, 2, 1, 1, 1, 1};
    private byte[] rStepX = new byte[]{2, 3, 2, 2, 3, 2, 2};
    private byte[] rStepY = new byte[]{2, 2, 1, 2, 1};
    private byte[] offsets = new byte[]{0, -12, 12, -1, 1};
    private final String[] levNames = new String[]{"dirt.sie", "lego.sie", "beach.sie", "wood.sie", "weird.sie", "casino.sie", "boxes.sie", "apples.sie", "package.sie", "books.sie"};
    private final short[] levLengths = new short[]{1120, 928, 1120, 1056, 1056, 1056, 1120, 1184, 1120, 1184};
    private final String[] INTRO = new String[]{"Written & designed", "by Karl H\u00f6rnell", "(c) OnGame, 2003"};
    private final String[] HELP = new String[]{"You control Pixel", "Pete, the penguin.", "Move ice blocks by", "pushing them ...", "... or crush them", "onto other blocks.", "Watch out for", "the flames.", "You can snuff", "them with ice.", "Collect all five", "golden coins ...", "... to get to", "the next level."};
    private char[][] HIGHSCORES = new char[8][14];
    private String[] MENUS = new String[]{"Play", "Settings", "Exit", "Start on level", "Sound", "Back", "OFF", "ON"};
    private int[] menuColor = new int[]{0xFFFFFF, 0x333333};
    char[] LEVELTEXT = new char[]{'L', 'e', 'v', 'e', 'l', ' ', '0', '1'};
    private String[] VARIOUS = new String[]{"Highscores", "GAME OVER", "DEMO"};
    private RecordStore rs;
    char[] scString = new char[5];
    private int[] menuX = new int[6];
    private int[] menuY = new int[6];
    private int scoreX;
    private int selected;
    private final int[] motionKeys = new int[]{0, -59, -60, -61, -62, -1};
    Melody drunken;
    Melody morning;
    Melody crush;
    Melody freed;
    Melody snuffed;
    Melody killed;
    int[] drNotes = new int[]{47, 2, 47, 3, 47, 3, 47, 2, 47, 3, 47, 3, 47, 2, 40, 2, 43, 2, 47, 2};
    int[] moNotes = new int[]{50, 2, 47, 2, 45, 2, 42, 2, 40, 1, 40, 1};
    int[] crNotes = new int[]{36, 4, 38, 4, 40, 4, 41, 4, 43, 4};
    int[] frNotes = new int[]{45, 4, 48, 4, 50, 4, 52, 4, 53, 4, 55, 4, 57, 4};
    int[] snNotes = new int[]{53, 4, 52, 4, 50, 4, 48, 4, 47, 4};
    int[] kiNotes = new int[]{31, 4, 29, 4, 28, 4, 26, 4, 24, 4, 23, 4, 21, 4, 19, 4, 17, 4, 16, 4, 14, 4, 12, 4};

    public iceCanvas(iceplus iceplus2) {
        super(false);
        this.owner = iceplus2;
        this.f = Font.getFont((int)0, (int)1, (int)8);
        try {
            this.logo = Image.createImage((String)"/logo.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = 0;
        while (n < 10) {
            this.objs[n] = new iceObject();
            ++n;
        }
        n = 0;
        while (n < 1344) {
            this.tiles2[n] = -64;
            this.tiles3[n] = -64;
            ++n;
        }
        this.readPermanent();
        this.gameMode = 20;
        MelodyComposer melodyComposer = new MelodyComposer(this.drNotes, 230);
        this.drunken = melodyComposer.getMelody();
        melodyComposer = new MelodyComposer(this.moNotes, 200);
        this.morning = melodyComposer.getMelody();
        melodyComposer = new MelodyComposer(this.crNotes, 280);
        this.crush = melodyComposer.getMelody();
        melodyComposer = new MelodyComposer(this.frNotes, 260);
        this.freed = melodyComposer.getMelody();
        melodyComposer = new MelodyComposer(this.snNotes, 240);
        this.snuffed = melodyComposer.getMelody();
        melodyComposer = new MelodyComposer(this.kiNotes, 240);
        this.killed = melodyComposer.getMelody();
        this.runner = new Thread(this);
        this.runner.start();
    }

    private void readPermanent() {
        int n;
        int n2;
        int n3;
        try {
            this.rs = RecordStore.openRecordStore((String)"iceplus", (boolean)true);
            RecordEnumeration recordEnumeration = this.rs.enumerateRecords(null, null, false);
            if (recordEnumeration.hasNextElement()) {
                byte[] byArray = recordEnumeration.nextRecord();
                n3 = 0;
                n2 = 0;
                while (n2 < 8) {
                    n = 0;
                    while (n < 14) {
                        this.HIGHSCORES[n2][n] = (char)byArray[n3++];
                        ++n;
                    }
                    n = 4;
                    while (n < 9) {
                        this.highscores[n2] = 10 * this.highscores[n2] + (this.HIGHSCORES[n2][n] - 48);
                        ++n;
                    }
                    ++n2;
                }
                this.startLevel = byArray[n3++];
                this.maxLevel = byArray[n3++];
                this.soundOn = byArray[n3];
            }
            this.rs.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.HIGHSCORES[0][0] == '\u0000') {
            n2 = 0;
            while (n2 < 8) {
                n3 = 0;
                this.HIGHSCORES[n2][n3++] = (char)(49 + n2);
                this.HIGHSCORES[n2][n3++] = 46;
                this.HIGHSCORES[n2][n3++] = 32;
                this.HIGHSCORES[n2][n3++] = 32;
                n = 0;
                while (n < 5) {
                    this.HIGHSCORES[n2][n3++] = 48;
                    ++n;
                }
                this.HIGHSCORES[n2][n3++] = 32;
                this.HIGHSCORES[n2][n3++] = 32;
                n = 0;
                while (n < 3) {
                    this.HIGHSCORES[n2][n3++] = 46;
                    ++n;
                }
                ++n2;
            }
        }
    }

    private void storePermanent() {
        try {
            byte[] byArray = new byte[115];
            int n = 0;
            int n2 = 0;
            while (n2 < 8) {
                int n3 = 0;
                while (n3 < 14) {
                    byArray[n++] = (byte)this.HIGHSCORES[n2][n3];
                    ++n3;
                }
                ++n2;
            }
            byArray[112] = (byte)this.startLevel;
            byArray[113] = (byte)this.maxLevel;
            byArray[114] = (byte)this.soundOn;
            this.rs = RecordStore.openRecordStore((String)"iceplus", (boolean)true);
            if (this.rs.getNumRecords() > 0) {
                this.rs.deleteRecord(this.rs.getNextRecordID() - 1);
            }
            this.rs.addRecord(byArray, 0, 115);
            this.rs.closeRecordStore();
        }
        catch (Exception exception) {}
    }

    void prepareSpritesAndStuff() {
        byte[] byArray;
        int n;
        int n2;
        InputStream inputStream;
        byte[] byArray2 = new byte[13600];
        byte[] byArray3 = new byte[192];
        this.topSprites = new Sprite[48];
        this.botSprites = new Sprite[46];
        this.shadowSprites = new Sprite[2];
        try {
            inputStream = this.getClass().getResourceAsStream("spritedata.sie");
            n2 = 1;
            n = 0;
            while (n2 > 0) {
                n2 = inputStream.read(byArray2, n, 13600 - n);
                n += n2;
            }
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        n = 0;
        n2 = 0;
        while (n2 < 46) {
            int n3 = 16 * (this.spriteEffH[n2] - 12);
            byArray = new byte[n3];
            int n4 = 0;
            while (n3 > 0) {
                byArray[n4++] = byArray2[n++];
                --n3;
            }
            n3 = 16 * (12 + this.spriteH[n2] - this.spriteEffH[n2]);
            n4 = 0;
            while (n3 > 0) {
                byArray3[n4++] = byArray2[n++];
                --n3;
            }
            n3 = 16 * (this.spriteEffH[n2] - this.spriteH[n2]);
            while (n3 > 0) {
                byArray3[n4++] = -64;
                --n3;
            }
            try {
                this.topSprites[n2] = new Sprite(com.siemens.mp.ui.Image.createRGBImage((byte[])byArray, (int)16, (int)(this.spriteEffH[n2] - 12), (int)5));
                this.botSprites[n2] = new Sprite(com.siemens.mp.ui.Image.createRGBImage((byte[])byArray3, (int)16, (int)12, (int)5));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n2;
        }
        try {
            byArray = new byte[128];
            n2 = 0;
            while (n2 < 128) {
                byArray[n2] = byArray2[n++];
                ++n2;
            }
            this.topSprites[46] = new Sprite(com.siemens.mp.ui.Image.createRGBImage((byte[])byArray, (int)16, (int)8, (int)5));
            byArray = new byte[112];
            n2 = 0;
            while (n2 < 112) {
                byArray[n2] = byArray2[n++];
                ++n2;
            }
            this.topSprites[47] = new Sprite(com.siemens.mp.ui.Image.createRGBImage((byte[])byArray, (int)16, (int)7, (int)5));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            inputStream = this.getClass().getResourceAsStream("icedata.sie");
            n2 = 1;
            n = 0;
            while (n2 > 0) {
                n2 = inputStream.read(byArray2, n, 1408 - n);
                n += n2;
            }
            inputStream.close();
            n2 = 0;
            while (n2 < 768) {
                this.tiles2[n2] = byArray2[n2];
                ++n2;
            }
            n2 = 0;
            while (n2 < 640) {
                this.tiles3[n2] = byArray2[768 + n2];
                ++n2;
            }
        }
        catch (Exception exception) {}
    }

    void adjustStrings() {
        int n = 0;
        while (n < 3) {
            this.menuY[n] = 71;
            ++n;
        }
        this.menuX[0] = 1;
        this.menuX[1] = 50 - this.f.stringWidth(this.MENUS[1]) / 2;
        this.menuX[2] = 100 - this.f.stringWidth(this.MENUS[2]);
        n = 3;
        while (n < 6) {
            this.menuY[n] = 17 + 12 * (n - 3);
            ++n;
        }
        this.menuX[3] = 38 - this.f.stringWidth(this.MENUS[3]) / 2;
        this.menuX[4] = 38 - this.f.stringWidth(this.MENUS[4]) / 2;
        this.menuX[5] = 50 - this.f.stringWidth(this.MENUS[4]) / 2;
    }

    void setUpIntroScreen(Graphics graphics) {
        graphics.drawImage(this.logo, 0, 0, 20);
        int n = 0;
        while (n < 3) {
            this.objs[n].x = -20;
            this.objs[n].y = 71;
            this.objs[n].look = 0;
            ++n;
        }
        this.introCount = -1;
        this.prepareMenu(0, graphics);
        this.buildShadows((byte)12);
        this.advanceIntro(graphics);
        this.scoreX = 0;
        n = 0;
        while (n < 8) {
            this.scoreX += this.f.charsWidth(this.HIGHSCORES[n], 0, 14);
            ++n;
        }
        this.scoreX = 50 - this.scoreX / 16;
        this.gameMode = 2;
    }

    void prepareMenu(int n, Graphics graphics) {
        this.selected = n;
        this.vPrint(this.menuX[n], this.menuY[n], this.MENUS[n], 0xFFFFFF, graphics);
        this.vPrint(this.menuX[n + 1], this.menuY[n + 1], this.MENUS[n + 1], 0xFFFFFF, graphics);
        this.vPrint(this.menuX[n + 2], this.menuY[n + 2], this.MENUS[n + 2], 0xFFFFFF, graphics);
    }

    void buildShadows(byte by) {
        int n = 0;
        while (n < 128) {
            this.squareShadow[n] = by;
            this.roundShadow[n] = this.shadBytes[n] > 0 ? by : (byte)-64;
            ++n;
        }
        try {
            this.shadowSprites[1] = new Sprite(com.siemens.mp.ui.Image.createRGBImage((byte[])this.roundShadow, (int)16, (int)8, (int)5));
            this.shadowSprites[0] = new Sprite(com.siemens.mp.ui.Image.createRGBImage((byte[])this.squareShadow, (int)16, (int)8, (int)5));
        }
        catch (IOException iOException) {}
    }

    void vPrint(int n, int n2, String string, int n3, Graphics graphics) {
        graphics.setFont(this.f);
        graphics.setColor(0);
        graphics.drawString(string, n + 1, n2 + 1, 20);
        graphics.setColor(n3);
        graphics.drawString(string, n, n2, 20);
    }

    void vPrint(int n, int n2, char[] cArray, int n3, int n4, Graphics graphics) {
        graphics.setFont(this.f);
        graphics.setColor(0);
        graphics.drawChars(cArray, n3, n4, n + 1, n2 + 1, 20);
        graphics.setColor(0xFFFFFF);
        graphics.drawChars(cArray, n3, n4, n, n2, 20);
    }

    void addObject(int n, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < 9 && this.objs[n5].type > 0) {
            ++n5;
        }
        this.objs[n5].type = n;
        this.objs[n5].pos = n2;
        this.objs[n5].look = n3;
        this.objs[n5].dir = n4;
        this.objs[n5].x = n2 % 12 << 4;
        this.objs[n5].y = (n2 / 12 << 3) + 28;
        this.objs[n5].step = 0;
    }

    void advanceIntro(Graphics graphics) {
        ++this.introCount;
        if (this.introCount > 8) {
            this.introCount = 0;
        }
        this.counter = 0;
        graphics.setClip(0, 31, 101, 40);
        graphics.drawImage(this.logo, 0, 0, 20);
        if (this.introCount < 7) {
            this.vPrint(2, 31, this.HELP[this.introCount << 1], 0xFFFFFF, graphics);
            this.vPrint(2, 40, this.HELP[(this.introCount << 1) + 1], 0xFFFFFF, graphics);
        } else {
            int n = this.introCount - 7 << 2;
            int n2 = 33;
            int n3 = n;
            while (n3 < n + 4) {
                this.vPrint(this.scoreX, n2, this.HIGHSCORES[n3], 0, 14, graphics);
                n2 += 9;
                ++n3;
            }
        }
        graphics.setClip(0, 0, 101, 80);
    }

    void drawSprite(iceObject iceObject2, int n, Graphics graphics) {
        if (n == 1) {
            this.botSprites[iceObject2.look].setPosition(iceObject2.x - this.offsX, iceObject2.y - 12 - this.offsY);
            this.botSprites[iceObject2.look].paint(graphics);
        } else if (n == 2) {
            this.topSprites[iceObject2.look].setPosition(iceObject2.x - this.offsX, iceObject2.y - this.spriteEffH[iceObject2.look] - this.offsY);
            this.topSprites[iceObject2.look].paint(graphics);
        } else if (this.shadowX[iceObject2.look] > 0) {
            this.shadowSprites[this.shadowType[iceObject2.look]].setPosition(iceObject2.x - this.offsX + this.shadowX[iceObject2.look], iceObject2.y - 8 - this.offsY);
            this.shadowSprites[this.shadowType[iceObject2.look]].paint(graphics);
        }
    }

    void animateIntro(Graphics graphics) {
        switch (this.introCount) {
            case 0: {
                if (this.counter < 49) {
                    this.objs[0].look = 11 + this.cyclic[(this.counter & 7) >> 1];
                    this.objs[0].x = this.counter - 10 << 1;
                    break;
                }
                if (this.counter < 86) {
                    this.objs[0].look = 6;
                    this.objs[1].look = 18;
                    this.objs[1].x = this.counter - 60 << 1;
                    break;
                }
                if (this.counter < 103) {
                    this.objs[2].look = 25;
                    this.objs[2].x = this.counter - 97 << 1;
                    break;
                }
                this.advanceIntro(graphics);
                break;
            }
            case 1: {
                if (this.counter < 7) {
                    this.objs[0].x -= 2;
                    this.objs[0].look = 8 + this.cyclic[(this.counter & 7) >> 1];
                    break;
                }
                if (this.counter < 15) {
                    this.objs[1].x -= 3;
                    break;
                }
                if (this.counter <= 30) break;
                this.advanceIntro(graphics);
                break;
            }
            case 2: {
                if (this.counter < 12) {
                    this.objs[0].x -= 2;
                    this.objs[0].look = 8 + this.cyclic[(this.counter & 7) >> 1];
                    break;
                }
                if (this.objs[1].look < 24) {
                    if ((this.counter & 1) <= 0) break;
                    ++this.objs[1].look;
                    break;
                }
                if (this.counter < 32) {
                    this.objs[1].x = -30;
                    this.objs[0].x -= 2;
                    this.objs[0].look = 8 + this.cyclic[(this.counter & 7) >> 1];
                    break;
                }
                this.objs[0].look = 6;
                this.objs[1].x = 102;
                this.advanceIntro(graphics);
                break;
            }
            case 3: {
                this.objs[1].look = 14 + this.cyclic2[this.counter % 6];
                if (this.counter < 25) {
                    this.objs[1].x -= 2;
                    break;
                }
                if (this.counter < 45) break;
                if (this.counter < 70) {
                    this.objs[1].x += 2;
                    break;
                }
                this.objs[1].x = -30;
                this.advanceIntro(graphics);
                break;
            }
            case 4: {
                this.objs[1].look = this.counter < 16 ? 14 + this.cyclic2[this.counter % 6] : 42 + (this.counter & 1);
                if (this.counter < 13) {
                    this.objs[1].x += 2;
                    break;
                }
                if (this.counter < 42) {
                    this.objs[2].x -= 3;
                    this.objs[0].look = 10;
                    this.objs[1].x += this.counter & 1;
                    break;
                }
                if (this.counter < 50) {
                    this.objs[1].x = -30;
                    break;
                }
                this.objs[0].look = 6;
                this.objs[1].x = 102;
                this.objs[2].x = 102;
                this.objs[1].look = 18;
                this.advanceIntro(graphics);
                break;
            }
            case 5: {
                if (this.counter < 22) {
                    this.objs[2].x -= 2;
                    break;
                }
                if (this.counter < 35) {
                    this.objs[1].x -= 2;
                    break;
                }
                if (this.counter < 44) {
                    this.objs[0].x += 2;
                    this.objs[0].look = 11 + this.cyclic[(this.counter & 7) >> 1];
                    break;
                }
                this.advanceIntro(graphics);
                break;
            }
            case 6: {
                if (this.counter < 13) {
                    this.objs[2].look += this.counter & 1;
                    break;
                }
                if (this.counter < 50) {
                    this.objs[2].x = -30;
                    this.objs[0].look = (this.counter & 4) >> 2;
                    break;
                }
                if (this.counter <= 80) break;
                this.objs[0].x = -30;
                this.objs[1].x = -30;
                this.advanceIntro(graphics);
                break;
            }
            default: {
                if (this.counter <= 80) break;
                this.advanceIntro(graphics);
            }
        }
    }

    void updateScore(int n) {
        int n2 = 4;
        this.score += n;
        int n3 = this.score;
        while (n2 >= 0) {
            this.scString[n2] = (char)(48 + n3 % 10);
            n3 /= 10;
            --n2;
        }
    }

    void startSession() {
        this.gameMode = 3;
        this.level = this.startLevel;
        this.lives = 2;
        this.score = 0;
        this.updateScore(0);
        this.clipX = 48;
        this.clipW = 5;
        this.clipY = 36;
        this.clipH = 8;
    }

    void prepareEnemies() {
        int n = 0;
        int n2 = 0;
        int n3 = this.level > 19 ? 19 : this.level;
        while (n < this.levFl1[n3]) {
            this.enemies[n2++] = 6;
            ++n;
        }
        n = 0;
        while (n < this.levFl2[n3]) {
            this.enemies[n2++] = 7;
            ++n;
        }
        while (n2 < 4) {
            this.enemies[n2++] = 0;
        }
    }

    void prepareLevel() {
        int[] nArray = new int[]{0, 9, 5, 7};
        if (this.level < 20) {
            nArray[1] = this.levIce[this.level];
            nArray[3] = this.levRock[this.level];
        }
        this.buildMap(nArray);
        this.loadLevelGraphics(this.level / 2 % 10);
        this.buildTiles();
        int n = 0;
        while (n < 10) {
            this.objs[n].type = 0;
            ++n;
        }
        this.addObject(1, 13, 11, 0);
        this.layer1.setPosition(-12, -4);
        this.layer2.setPosition(-12, -4);
        this.layer3.setPosition(-12, 0);
        this.coins = 0;
    }

    void buildMap(int[] nArray) {
        int n;
        short[] sArray = new short[180];
        int n2 = 0;
        while (n2 < 5) {
            int n3;
            int n4;
            n = 0;
            while (n < 12) {
                n4 = 0;
                while (n4 < 12) {
                    n3 = n * 12 + n4;
                    this.map[n3] = n > 0 && n < 11 && n4 > 0 && n4 < 11 ? 0 : 3;
                    ++n4;
                }
                ++n;
            }
            this.map[13] = 4;
            this.map[143] = 0;
            n4 = 1;
            while (n4 < 4) {
                n = 0;
                while (n < nArray[n4]) {
                    n3 = 0;
                    while (this.map[n3] != 0) {
                        n3 = 12 + (this.rnd.nextInt() & 0xFFF) % 120;
                        if (this.map[n3] != 0) {
                            n3 = 0;
                            continue;
                        }
                        this.map[n3] = n4;
                        n3 = 143;
                    }
                    ++n;
                }
                ++n4;
            }
            this.map[13] = 4;
            sArray[0] = 13;
            n = 0;
            n4 = 1;
            n2 = 0;
            while (n < n4) {
                n3 = sArray[n++];
                int n5 = 1;
                while (n5 < 5) {
                    if (this.map[n3 + this.offsets[n5]] < 3) {
                        sArray[n4++] = (short)(n3 + this.offsets[n5]);
                        if (this.map[n3 + this.offsets[n5]] == 2) {
                            ++n2;
                        }
                        int n6 = n3 + this.offsets[n5];
                        this.map[n6] = this.map[n6] | 4;
                    }
                    ++n5;
                }
            }
        }
        this.map[143] = 3;
        n = 0;
        while (n < 144) {
            int n7 = n++;
            this.map[n7] = this.map[n7] & 3;
        }
    }

    void loadLevelGraphics(int n) {
        int n2;
        int n3;
        byte[] byArray = new byte[this.levLengths[n]];
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(this.levNames[n]);
            n3 = 1;
            n2 = 0;
            while (n3 > 0) {
                n3 = inputStream.read(byArray, n2, this.levLengths[n] - n2);
                n2 += n3;
            }
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.levGround = 1 + (this.levLengths[n] - 928) / 64;
        n3 = 0;
        while (n3 < 32) {
            this.tiles2[768 + n3] = byArray[32 + n3];
            this.tiles2[832 + n3] = byArray[96 + n3];
            this.tiles2[800 + n3] = byArray[128 + n3];
            this.tiles2[864 + n3] = byArray[224 + n3];
            this.tiles2[1024 + n3] = byArray[32 + n3];
            this.tiles3[832 + n3] = byArray[224 + n3];
            this.tiles3[896 + n3] = byArray[320 + n3];
            ++n3;
        }
        n3 = 0;
        while (n3 < 64) {
            this.tiles2[896 + n3] = byArray[160 + n3];
            this.tiles2[960 + n3] = byArray[256 + n3];
            ++n3;
        }
        n3 = 0;
        while (n3 < 96) {
            this.tiles2[1056 + n3] = byArray[320 + n3];
            ++n3;
        }
        n3 = 0;
        while (n3 < 128) {
            this.tiles1[n3] = byArray[800 + n3];
            ++n3;
        }
        n3 = 0;
        while (n3 < 160) {
            this.tiles3[640 + n3] = byArray[n3];
            ++n3;
        }
        n3 = 0;
        while (n3 < 384) {
            this.tiles3[960 + n3] = byArray[416 + n3];
            ++n3;
        }
        n2 = 64 * (this.levGround - 1);
        n3 = 0;
        while (n3 < n2) {
            this.tiles2[1152 + n3] = byArray[928 + n3];
            ++n3;
        }
        this.buildShadows(this.tiles1[64]);
        try {
            this.layer1 = new TiledLayer(24, 15, com.siemens.mp.ui.Image.createRGBImage((byte[])this.tiles1, (int)8, (int)16, (int)5), 8, 8);
            this.layer2 = new TiledLayer(24, 15, com.siemens.mp.ui.Image.createRGBImage((byte[])this.tiles2, (int)8, (int)176, (int)5), 8, 8);
            this.layer3 = new TiledLayer(24, 15, com.siemens.mp.ui.Image.createRGBImage((byte[])this.tiles3, (int)8, (int)168, (int)5), 8, 8);
        }
        catch (Exception exception) {}
    }

    void buildTiles() {
        int n = 0;
        int n2 = 0;
        while (n2 < 360) {
            this.decoLayer[n2] = 0;
            ++n2;
        }
        n2 = 0;
        while (n2 < 15) {
            n = 0;
            while (n < 24) {
                this.layer2.setCell(n, n2, 0);
                this.layer3.setCell(n, n2, 0);
                ++n;
            }
            ++n2;
        }
        n2 = 4;
        while (n2 < 13) {
            n = 0;
            while (n < 24) {
                this.layer1.setCell(n, n2, 1);
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < 24) {
            this.layer3.setCell(n, 0, 16 + n % 6);
            ++n;
        }
        n2 = 1;
        while (n2 < this.levGround) {
            n = 0;
            while (n < 20) {
                int n3 = 96 + (this.rnd.nextInt() & 0xFF);
                this.decoLayer[n3] = 18 + n2;
                this.layer2.setCell(n3 % 24, n3 / 24, 18 + n2);
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < 144) {
            if (this.map[n2] > 0) {
                this.addBlock(n2, this.map[n2]);
            }
            ++n2;
        }
    }

    void addBlock(int n, int n2) {
        int n3 = n / 12;
        int n4 = n % 12;
        this.map[n] = n2;
        int n5 = n2 + (n2 << 2) - 4;
        int n6 = ((n2 << 1) + n2 << 1) - 5;
        int n7 = n + n + 24;
        int n8 = n7 % 24;
        int n9 = n7 / 24;
        this.layer3.setCell(n8, n9, n5);
        this.layer3.setCell(n8 + 1, n9, n5 + 1);
        if (n3 == 11 || (this.map[n + 12] & 3) == 0) {
            this.layer3.setCell(n8 + 1, n9 + 1, n5 + 3);
            this.layer2.setCell(n8 + 1, n9 + 1, n6 + 1);
            this.layer2.setCell(n8 + 1, n9 + 2, n6 + 3);
            if (n4 > 0 && n3 < 11 && (this.map[n + 11] & 3) > 0) {
                this.layer3.setCell(n8, n9 + 1, n5 + 4);
                this.layer2.setCell(n8, n9 + 1, n6 + 4);
                this.layer2.setCell(n8, n9 + 2, n6 + 5);
            } else {
                this.layer3.setCell(n8, n9 + 1, n5 + 2);
                this.layer2.setCell(n8, n9 + 1, n6);
                this.layer2.setCell(n8, n9 + 2, n6 + 2);
            }
        }
        if (n4 < 11) {
            this.layer1.setCell(n8 + 2, n9 + 2, 2);
        }
        if (n3 > 0 && n4 < 11 && (this.map[n - 11] & 3) > 0 && (this.map[n + 1] & 3) == 0) {
            n5 = this.map[n - 11] + (this.map[n - 11] << 2) - 4;
            n6 = ((this.map[n - 11] << 1) + this.map[n - 11] << 1) - 5;
            this.layer3.setCell(n8 + 2, n9, n5 + 4);
            this.layer2.setCell(n8 + 2, n9, n6 + 4);
            this.layer2.setCell(n8 + 2, n9 + 1, n6 + 5);
        }
    }

    void removeBlock(int n) {
        int n2;
        int n3;
        int n4;
        int n5 = n / 12;
        int n6 = n % 12;
        int n7 = n + n + 24;
        int n8 = n7 % 24;
        int n9 = n7 / 24;
        this.layer3.setCell(n8, n9, 0);
        this.layer3.setCell(n8 + 1, n9, 0);
        this.layer2.setCell(n8, n9 + 1, this.decoLayer[n7 + 24]);
        this.layer2.setCell(n8 + 1, n9 + 1, this.decoLayer[n7 + 25]);
        if ((this.map[n - 12] & 3) > 0) {
            n4 = this.map[n - 12];
            n3 = n4 + (n4 << 2) - 4;
            n2 = ((n4 << 1) + n4 << 1) - 5;
            this.layer3.setCell(n8 + 1, n9, n3 + 3);
            this.layer2.setCell(n8 + 1, n9, n2 + 1);
            this.layer2.setCell(n8 + 1, n9 + 1, n2 + 3);
            if (n6 > 0 && n5 < 11 && (this.map[n - 1] & 3) > 0) {
                this.layer3.setCell(n8, n9, n3 + 4);
                this.layer2.setCell(n8, n9, n2 + 4);
                this.layer2.setCell(n8, n9 + 1, n2 + 5);
            } else {
                this.layer3.setCell(n8, n9, n3 + 2);
                this.layer2.setCell(n8, n9, n2);
                this.layer2.setCell(n8, n9 + 1, n2 + 2);
            }
        }
        if ((this.map[n + 1] & 3) == 0 && (this.map[n - 11] & 3) > 0) {
            n4 = this.map[n - 11];
            n3 = n4 + (n4 << 2) - 4;
            n2 = ((n4 << 1) + n4 << 1) - 5;
            this.layer3.setCell(n8 + 2, n9, n3 + 2);
            this.layer2.setCell(n8 + 2, n9, n2);
            this.layer2.setCell(n8 + 2, n9 + 1, n2 + 2);
        }
        if ((this.map[n + 12] & 3) == 0) {
            this.layer3.setCell(n8, n9 + 1, 0);
            this.layer3.setCell(n8 + 1, n9 + 1, 0);
            this.layer2.setCell(n8, n9 + 2, this.decoLayer[n7 + 48]);
            this.layer2.setCell(n8 + 1, n9 + 2, this.decoLayer[n7 + 49]);
        }
        this.layer1.setCell(n8 + 2, n9 + 2, 1);
    }

    void sortSprites() {
        this.sortN = 0;
        int n = 0;
        while (n < 10) {
            if (this.objs[n].type > 0) {
                this.sortY[this.sortN] = this.objs[n].y;
                if (this.objs[n].type == 8) {
                    int n2 = this.sortN;
                    this.sortY[n2] = this.sortY[n2] + 100;
                }
                this.sortIX[this.sortN++] = n;
            }
            ++n;
        }
        int n3 = 1;
        while (n3 < this.sortN) {
            n = 0;
            while (n < n3) {
                if (this.sortY[n] > this.sortY[n3]) {
                    int n4 = this.sortY[n3];
                    this.sortY[n3] = this.sortY[n];
                    this.sortY[n] = n4;
                    n4 = this.sortIX[n3];
                    this.sortIX[n3] = this.sortIX[n];
                    this.sortIX[n] = n4;
                }
                ++n;
            }
            ++n3;
        }
    }

    void prepareHighscores(Graphics graphics) {
        int n;
        int n2 = 7;
        while (n2 > 0 && this.score > this.highscores[n2 - 1]) {
            n = 3;
            while (n < 14) {
                this.HIGHSCORES[n2][n] = this.HIGHSCORES[n2 - 1][n];
                ++n;
            }
            this.highscores[n2] = this.highscores[n2 - 1];
            --n2;
        }
        this.highscores[n2] = this.score;
        n = 0;
        while (n < 5) {
            this.HIGHSCORES[n2][4 + n] = this.scString[n];
            ++n;
        }
        n = 0;
        while (n < 3) {
            this.HIGHSCORES[n2][11 + n] = 46;
            ++n;
        }
        this.highRow = n2;
        this.highCol = 11;
        graphics.setColor(171);
        graphics.fillRect(0, 0, 101, 80);
        this.vPrint(50 - this.f.stringWidth(this.VARIOUS[0]) / 2, 0, this.VARIOUS[0], 0xFFFFFF, graphics);
        n2 = 0;
        while (n2 < 8) {
            this.vPrint(this.scoreX, 10 + n2 * 9, this.HIGHSCORES[n2], 0, 14, graphics);
            ++n2;
        }
        this.topSprites[47].setPosition(this.scoreX - 13, 11 + this.highRow * 9);
        this.topSprites[47].paint(graphics);
        this.gameMode = 9;
    }

    void prepareSettings(Graphics graphics) {
        graphics.setColor(0xA00000);
        graphics.fillRect(0, 0, 101, 80);
        this.prepareMenu(3, graphics);
        this.vPrint(50 - this.f.stringWidth(this.MENUS[1]) / 2, 3, this.MENUS[1], 0xFFFFFF, graphics);
        this.objs[0].x = 42;
        this.objs[1].x = 12;
        this.objs[2].x = 72;
        this.objs[0].y = 77;
        this.objs[1].y = 77;
        this.objs[2].y = 77;
        this.objs[0].look = 6;
        this.objs[1].look = 18;
        this.objs[2].look = 25;
        this.buildShadows((byte)64);
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            while (n2 < 3) {
                this.drawSprite(this.objs[n2], n, graphics);
                ++n2;
            }
            ++n;
        }
        this.gameMode = 10;
    }

    public void run() {
        while (this.lastKey != 1024) {
            long l = System.currentTimeMillis();
            ++this.counter;
            this.repaint(0, 0, 101, 80);
            this.serviceRepaints();
            long l2 = System.currentTimeMillis() - l;
            try {
                if (l2 < 65L) {
                    Thread.sleep(75L - l2);
                    continue;
                }
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.owner.exitRequested();
    }

    public void paint(Graphics graphics) {
        switch (this.gameMode) {
            case 0: {
                if (System.currentTimeMillis() <= this.modeTime) break;
                this.gameMode = this.nextMode;
                break;
            }
            case 1: {
                this.setUpIntroScreen(graphics);
                break;
            }
            case 2: {
                if (this.introCount < 7) {
                    graphics.setClip(0, 49, 101, 22);
                    graphics.drawImage(this.logo, 0, 0, 20);
                    graphics.setClip(0, 0, 101, 80);
                }
                this.animateIntro(graphics);
                int n = 0;
                while (n < 3) {
                    int n2 = 0;
                    while (n2 < 3) {
                        this.drawSprite(this.objs[n2], n, graphics);
                        ++n2;
                    }
                    ++n;
                }
                if (this.lastKey != this.oldKey) {
                    this.oldKey = this.lastKey;
                    if (this.lastKey == this.motionKeys[3]) {
                        if (this.selected > 0) {
                            this.vPrint(this.menuX[this.selected], this.menuY[this.selected], this.MENUS[this.selected], 0xFFFFFFF, graphics);
                            --this.selected;
                        }
                    } else if (this.lastKey == this.motionKeys[4] && this.selected < 2) {
                        this.vPrint(this.menuX[this.selected], this.menuY[this.selected], this.MENUS[this.selected], 0xFFFFFF, graphics);
                        ++this.selected;
                    }
                }
                this.vPrint(this.menuX[this.selected], this.menuY[this.selected], this.MENUS[this.selected], this.menuColor[(this.counter & 4) >> 2], graphics);
                if (this.lastKey != this.motionKeys[5]) break;
                if (this.selected == 0) {
                    this.startSession();
                    break;
                }
                if (this.selected == 1) {
                    this.prepareSettings(graphics);
                    break;
                }
                this.owner.exitRequested();
                break;
            }
            case 3: {
                graphics.setColor(0);
                graphics.fillRect(this.clipX, this.clipY, this.clipW, this.clipH);
                this.clipX -= 4;
                this.clipY -= 3;
                this.clipW += 8;
                this.clipH += 6;
                if (this.clipX >= 0) break;
                this.clipX = 48;
                this.clipW = 5;
                this.clipY = 36;
                this.clipH = 8;
                int n = 1;
                while (n < 10) {
                    this.objs[n].type = 0;
                    ++n;
                }
                this.gameMode = 5;
                graphics.setColor(0xFFFFFF);
                this.LEVELTEXT[6] = (char)(48 + (this.level + 1) / 10 % 10);
                this.LEVELTEXT[7] = (char)(48 + (this.level + 1) % 10);
                graphics.setFont(this.f);
                graphics.drawChars(this.LEVELTEXT, 0, 8, 50 - this.f.charsWidth(this.LEVELTEXT, 0, 8) / 2, 19, 20);
                this.counter = 0;
                this.offsX = 0;
                this.offsY = 0;
                this.objs[0].x = 42;
                this.objs[0].y = 60;
                this.objs[0].look = 15;
                this.prepareEnemies();
                int n3 = 12;
                n = 3;
                while (this.enemies[n] == 0) {
                    n3 += 10;
                    --n;
                }
                n = 0;
                while (n < 4) {
                    this.objs[n].y = 60;
                    this.objs[n].x = n3;
                    n3 += 20;
                    if (this.enemies[n] > 0) {
                        this.objs[n].look = this.enemies[n] == 6 ? 15 : 38;
                        this.drawSprite(this.objs[n], 1, graphics);
                        this.drawSprite(this.objs[n], 2, graphics);
                    }
                    ++n;
                }
                break;
            }
            case 4: {
                graphics.setClip(this.clipX, this.clipY, this.clipW, this.clipH);
                this.layer1.paint(graphics);
                this.layer2.paint(graphics);
                this.layer3.paint(graphics);
                this.clipX -= 4;
                this.clipY -= 3;
                this.clipW += 8;
                this.clipH += 6;
                if (this.clipX >= 0) break;
                this.gameMode = 6;
                break;
            }
            case 5: {
                if (this.counter <= 15) break;
                this.prepareLevel();
                this.gameMode = 4;
                break;
            }
            case 6: {
                int n;
                int n4;
                int n5 = this.counter >> 4 & 3;
                if (this.enemies[n5] > 0) {
                    if (this.objs[0].x < 72) {
                        n4 = 23;
                        n = 3;
                    } else {
                        n4 = 12;
                        n = 4;
                    }
                    n4 += 12 * (this.rnd.nextInt() & 7);
                    while (n4 < 122 && this.map[n4 + this.offsets[n]] > 0) {
                        n4 += 12;
                    }
                    if (n4 < 122) {
                        this.addObject(this.enemies[n5], n4, 0, n);
                        this.enemies[n5] = 0;
                    }
                }
                n5 = 0;
                while (n5 < 10) {
                    switch (this.objs[n5].type) {
                        case 1: {
                            if ((this.objs[n5].x & 0xF) == 0 && (this.objs[n5].y & 7) == 4) {
                                this.objs[n5].step = 0;
                                this.objs[n5].dir = 0;
                                n4 = 1;
                                while (n4 < 5) {
                                    if (this.lastKey == this.motionKeys[n4]) {
                                        n = this.objs[n5].pos + this.offsets[n4];
                                        if (this.map[n] == 0) {
                                            this.objs[n5].dir = n4;
                                            this.objs[n5].pos += this.offsets[n4];
                                        } else if (this.map[n] == 1 || this.map[n] == 2) {
                                            if ((this.map[n + this.offsets[n4]] & 3) == 0) {
                                                this.addObject(this.map[n] + 1, n, 11 + 7 * this.map[n], n4);
                                                this.map[n] = 0;
                                                this.removeBlock(n);
                                            } else {
                                                if (this.soundOn != 0) {
                                                    this.crush.play();
                                                }
                                                this.addObject(this.map[n] + 3, n, 11 + 7 * this.map[n], 0);
                                                this.map[n] = 4;
                                                this.removeBlock(n);
                                            }
                                            this.objs[n5].look = n4 * 3 - 1 + this.cyclic[(this.counter & 6) >> 1];
                                        }
                                    }
                                    ++n4;
                                }
                            }
                            if (this.objs[n5].dir > 0) {
                                switch (this.objs[n5].dir) {
                                    case 1: {
                                        this.objs[n5].y -= this.pStepY[this.objs[n5].step];
                                        break;
                                    }
                                    case 2: {
                                        this.objs[n5].y += this.pStepY[this.objs[n5].step];
                                        break;
                                    }
                                    case 3: {
                                        this.objs[n5].x -= this.pStepX[this.objs[n5].step];
                                        break;
                                    }
                                    case 4: {
                                        this.objs[n5].x += this.pStepX[this.objs[n5].step];
                                        break;
                                    }
                                }
                                this.objs[n5].look = this.objs[n5].dir * 3 - 1 + this.cyclic[(this.counter & 6) >> 1];
                                ++this.objs[n5].step;
                            }
                            this.offsX = this.objs[n5].x - 42;
                            this.offsY = this.objs[n5].y - 48;
                            if (this.offsX < 12) {
                                this.offsX = 12;
                            } else if (this.offsX > 80) {
                                this.offsX = 80;
                            }
                            if (this.offsY < 0) {
                                this.offsY = 0;
                                break;
                            }
                            if (this.offsY <= 30) break;
                            this.offsY = 30;
                            break;
                        }
                        case 2: 
                        case 3: {
                            switch (this.objs[n5].dir) {
                                case 1: {
                                    this.objs[n5].y -= this.iStepY[this.objs[n5].step];
                                    break;
                                }
                                case 2: {
                                    this.objs[n5].y += this.iStepY[this.objs[n5].step];
                                    break;
                                }
                                case 3: {
                                    this.objs[n5].x -= this.iStepX[this.objs[n5].step];
                                    break;
                                }
                                case 4: {
                                    this.objs[n5].x += this.iStepX[this.objs[n5].step];
                                    break;
                                }
                            }
                            ++this.objs[n5].step;
                            if ((this.objs[n5].x & 0xF) == 0 && (this.objs[n5].y & 7) == 4) {
                                this.objs[n5].step = 0;
                                this.objs[n5].pos += this.offsets[this.objs[n5].dir];
                                if (this.map[this.objs[n5].pos + this.offsets[this.objs[n5].dir]] > 0) {
                                    this.addBlock(this.objs[n5].pos, this.objs[n5].type - 1);
                                    this.objs[n5].type = 0;
                                }
                            }
                            n4 = 1;
                            while (n4 < 10) {
                                if ((this.objs[n4].type & 0xE) == 6 && this.objs[n5].x < this.objs[n4].x + 13 && this.objs[n4].x < this.objs[n5].x + 13 && this.objs[n5].y < this.objs[n4].y + 8 && this.objs[n4].y < this.objs[n5].y + 8) {
                                    if (this.soundOn != 0) {
                                        this.snuffed.play();
                                    }
                                    if (this.objs[n4].type == 6) {
                                        this.objs[n4].look = 42;
                                        this.updateScore(50);
                                    } else {
                                        this.objs[n4].look = 44;
                                        this.updateScore(100);
                                    }
                                    n = 0;
                                    while (this.enemies[n] > 0) {
                                        ++n;
                                    }
                                    this.enemies[n] = this.objs[n4].type;
                                    this.objs[n4].type = 8;
                                    this.objs[n4].dir = 0;
                                }
                                ++n4;
                            }
                            break;
                        }
                        case 4: 
                        case 5: {
                            ++this.objs[n5].look;
                            if (this.objs[n5].look != 25 && this.objs[n5].look != 32) break;
                            this.map[this.objs[n5].pos] = 0;
                            if (this.objs[n5].type == 5) {
                                if (this.soundOn != 0) {
                                    this.freed.play();
                                }
                                ++this.coins;
                                this.updateScore(25);
                                if (this.coins == 5) {
                                    this.objs[0].look = 1;
                                    this.gameMode = 7;
                                    this.counter = 0;
                                }
                            } else {
                                this.updateScore(5);
                            }
                            this.objs[n5].type = 0;
                            break;
                        }
                        case 6: 
                        case 7: {
                            if (this.objs[n5].type == 6) {
                                this.objs[n5].look = 14 + this.cyclic2[this.counter % 6];
                                switch (this.objs[n5].dir) {
                                    case 1: {
                                        this.objs[n5].y -= this.fStepY[this.objs[n5].step];
                                        break;
                                    }
                                    case 2: {
                                        this.objs[n5].y += this.fStepY[this.objs[n5].step];
                                        break;
                                    }
                                    case 3: {
                                        this.objs[n5].x -= this.fStepX[this.objs[n5].step];
                                        break;
                                    }
                                    case 4: {
                                        this.objs[n5].x += this.fStepX[this.objs[n5].step];
                                        break;
                                    }
                                }
                            } else {
                                this.objs[n5].look = 38 + (this.counter & 3);
                                switch (this.objs[n5].dir) {
                                    case 1: {
                                        this.objs[n5].y -= this.rStepY[this.objs[n5].step];
                                        break;
                                    }
                                    case 2: {
                                        this.objs[n5].y += this.rStepY[this.objs[n5].step];
                                        break;
                                    }
                                    case 3: {
                                        this.objs[n5].x -= this.rStepX[this.objs[n5].step];
                                        break;
                                    }
                                    case 4: {
                                        this.objs[n5].x += this.rStepX[this.objs[n5].step];
                                        break;
                                    }
                                }
                            }
                            ++this.objs[n5].step;
                            if ((this.objs[n5].x & 0xF) == 0 && (this.objs[n5].y & 7) == 4) {
                                this.objs[n5].pos += this.offsets[this.objs[n5].dir];
                                this.objs[n5].step = 0;
                                if (this.objs[n5].dir == 0 || (this.counter & 0xE) == 0) {
                                    this.objs[n5].dir = 1 + (this.rnd.nextInt() & 3);
                                }
                                if (this.objs[n5].x < this.objs[0].x + 10 && this.objs[n5].x > this.objs[0].x - 10) {
                                    this.objs[n5].dir = this.objs[n5].y < this.objs[0].y ? 2 : 1;
                                } else if (this.objs[n5].y < this.objs[0].y + 7 && this.objs[n5].y > this.objs[0].y - 7) {
                                    this.objs[n5].dir = this.objs[0].x > this.objs[n5].x ? 4 : 3;
                                }
                                if (this.map[this.objs[n5].pos + this.offsets[this.objs[n5].dir]] > 0) {
                                    this.objs[n5].dir = 0;
                                }
                            }
                            if (this.objs[n5].x >= this.objs[0].x + 9 || this.objs[n5].x <= this.objs[0].x - 9 || this.objs[n5].y >= this.objs[0].y + 6 || this.objs[n5].y <= this.objs[0].y - 6) break;
                            if (this.soundOn != 0) {
                                this.killed.play();
                            }
                            this.objs[0].type = 9;
                            this.objs[0].look = 32;
                            n4 = 1;
                            while (n4 < 10) {
                                if ((this.objs[n4].type & 0xE) == 6) {
                                    this.objs[n4].type = 0;
                                }
                                ++n4;
                            }
                            n4 = 0;
                            while (n4 < 4) {
                                this.enemies[n4] = 0;
                                ++n4;
                            }
                            this.counter = 0;
                            break;
                        }
                        case 8: {
                            this.objs[n5].look = (this.objs[n5].look & 0x3E) + (this.counter & 1);
                            ++this.objs[n5].dir;
                            if (this.objs[n5].dir <= 15) break;
                            this.objs[n5].type = 0;
                            break;
                        }
                        case 9: {
                            if ((this.counter & 1) != 0 && this.objs[n5].look < 37) {
                                ++this.objs[n5].look;
                            }
                            if (this.counter <= 42) break;
                            --this.lives;
                            if (this.lives >= 0) {
                                this.objs[n5].look = 6;
                                this.objs[n5].type = 1;
                                this.prepareEnemies();
                                break;
                            }
                            if (this.soundOn != 0) {
                                this.morning.play();
                            }
                            this.gameMode = 8;
                            break;
                        }
                    }
                    ++n5;
                }
                this.sortSprites();
                this.layer1.setPosition(-this.offsX, -this.offsY - 4);
                this.layer1.paint(graphics);
                n5 = 0;
                while (n5 < this.sortN) {
                    this.drawSprite(this.objs[this.sortIX[n5]], 0, graphics);
                    ++n5;
                }
                this.layer2.setPosition(-this.offsX, -this.offsY - 4);
                this.layer2.paint(graphics);
                n5 = 0;
                while (n5 < this.sortN) {
                    this.drawSprite(this.objs[this.sortIX[n5]], 1, graphics);
                    ++n5;
                }
                this.layer3.setPosition(-this.offsX, -this.offsY);
                this.layer3.paint(graphics);
                n5 = 0;
                while (n5 < this.sortN) {
                    this.drawSprite(this.objs[this.sortIX[n5]], 2, graphics);
                    ++n5;
                }
                n = this.lives;
                n5 = 90;
                while (n > 0) {
                    this.topSprites[46].setPosition(n5, 0);
                    this.topSprites[46].paint(graphics);
                    --n;
                    n5 -= 11;
                }
                this.vPrint(0, 1, this.scString, 0, 5, graphics);
                break;
            }
            case 7: {
                this.objs[0].look = (this.counter & 2) >> 1;
                this.layer1.setPosition(-this.offsX, -this.offsY - 4);
                this.layer1.paint(graphics);
                this.drawSprite(this.objs[0], 0, graphics);
                this.layer2.setPosition(-this.offsX, -this.offsY - 4);
                this.layer2.paint(graphics);
                this.drawSprite(this.objs[0], 1, graphics);
                this.layer3.setPosition(-this.offsX, -this.offsY);
                this.layer3.paint(graphics);
                this.drawSprite(this.objs[0], 2, graphics);
                int n = this.lives;
                int n6 = 90;
                while (n > 0) {
                    this.topSprites[46].setPosition(n6, 0);
                    this.topSprites[46].paint(graphics);
                    --n;
                    n6 -= 11;
                }
                this.vPrint(0, 1, this.scString, 0, 5, graphics);
                if (this.soundOn != 0 && this.counter == 10) {
                    this.drunken.play();
                }
                if (this.counter <= 50) break;
                ++this.level;
                this.clipX = 48;
                this.clipW = 5;
                this.clipY = 36;
                this.clipH = 8;
                this.gameMode = 3;
                break;
            }
            case 8: {
                this.vPrint(50 - this.f.stringWidth(this.VARIOUS[1]) / 2, 40, this.VARIOUS[1], 0xFFFFFF, graphics);
                if (this.counter <= 100) break;
                this.offsX = 0;
                this.offsY = 0;
                if (this.level > this.maxLevel) {
                    this.maxLevel = this.level;
                }
                if (this.score > this.highscores[7]) {
                    this.prepareHighscores(graphics);
                    break;
                }
                this.buildShadows((byte)12);
                this.setNewMode(1, 200);
                break;
            }
            case 9: {
                if (this.lastKey != this.oldKey) {
                    this.oldKey = this.lastKey;
                    if (this.lastKey == this.motionKeys[3] && this.highCol > 11) {
                        --this.highCol;
                    } else if (this.lastKey == this.motionKeys[4] && this.highCol < 13) {
                        ++this.highCol;
                    } else if (this.lastKey == this.motionKeys[1]) {
                        if (this.HIGHSCORES[this.highRow][this.highCol] == '.') {
                            this.HIGHSCORES[this.highRow][this.highCol] = 65;
                        } else if (this.HIGHSCORES[this.highRow][this.highCol] == 'Z') {
                            this.HIGHSCORES[this.highRow][this.highCol] = 46;
                        } else {
                            char[] cArray = this.HIGHSCORES[this.highRow];
                            int n = this.highCol;
                            cArray[n] = (char)(cArray[n] + '\u0001');
                        }
                    } else if (this.lastKey == this.motionKeys[2]) {
                        if (this.HIGHSCORES[this.highRow][this.highCol] == '.') {
                            this.HIGHSCORES[this.highRow][this.highCol] = 90;
                        } else if (this.HIGHSCORES[this.highRow][this.highCol] == 'A') {
                            this.HIGHSCORES[this.highRow][this.highCol] = 46;
                        } else {
                            char[] cArray = this.HIGHSCORES[this.highRow];
                            int n = this.highCol;
                            cArray[n] = (char)(cArray[n] - '\u0001');
                        }
                    }
                }
                graphics.setColor(171);
                graphics.fillRect(this.scoreX, 10 + 9 * this.highRow, 101 - this.scoreX, 8);
                this.vPrint(this.scoreX, 10 + this.highRow * 9, this.HIGHSCORES[this.highRow], 0, 14, graphics);
                if (this.lastKey != this.motionKeys[5]) break;
                this.buildShadows((byte)12);
                this.storePermanent();
                this.setNewMode(1, 200);
                break;
            }
            case 10: {
                if (this.lastKey != this.oldKey) {
                    this.oldKey = this.lastKey;
                    if (this.lastKey == this.motionKeys[1]) {
                        if (this.selected > 3) {
                            this.vPrint(this.menuX[this.selected], this.menuY[this.selected], this.MENUS[this.selected], 0xFFFFFF, graphics);
                            --this.selected;
                        }
                    } else if (this.lastKey == this.motionKeys[2]) {
                        if (this.selected < 5) {
                            this.vPrint(this.menuX[this.selected], this.menuY[this.selected], this.MENUS[this.selected], 0xFFFFFF, graphics);
                            ++this.selected;
                        }
                    } else if (this.selected == 4 && this.lastKey != 0) {
                        this.soundOn = 1 - this.soundOn;
                    } else if (this.lastKey == this.motionKeys[3] && this.selected == 3) {
                        if (this.startLevel > 0) {
                            --this.startLevel;
                        }
                    } else if (this.lastKey == this.motionKeys[4] && this.selected == 3 && this.startLevel < this.maxLevel && this.startLevel < 50) {
                        ++this.startLevel;
                    }
                }
                this.vPrint(this.menuX[this.selected], this.menuY[this.selected], this.MENUS[this.selected], this.menuColor[(this.counter & 4) >> 2], graphics);
                graphics.setColor(0xA00000);
                graphics.fillRect(this.menuX[3] + this.f.stringWidth(this.MENUS[3]), this.menuY[3], 30, 11);
                graphics.fillRect(this.menuX[4] + this.f.stringWidth(this.MENUS[4]), this.menuY[4], 30, 11);
                this.LEVELTEXT[6] = (char)(48 + (this.startLevel + 1) / 10 % 10);
                this.LEVELTEXT[7] = (char)(48 + (this.startLevel + 1) % 10);
                this.vPrint(this.menuX[4] + this.f.stringWidth(this.MENUS[4]) + 5, this.menuY[4], this.MENUS[6 + this.soundOn], 0xFFFFFF, graphics);
                this.vPrint(this.menuX[3] + this.f.stringWidth(this.MENUS[3]) + 5, this.menuY[3], this.LEVELTEXT, 6, 2, graphics);
                if (this.lastKey != this.motionKeys[5] || this.selected != 5) break;
                this.buildShadows((byte)12);
                this.storePermanent();
                this.setNewMode(1, 200);
                break;
            }
            case 20: {
                graphics.drawImage(this.logo, 0, 0, 20);
                int n = 0;
                while (n < 3) {
                    this.vPrint(50 - this.f.stringWidth(this.INTRO[n]) / 2, 35 + 10 * n, this.INTRO[n], 0xFFFFFF, graphics);
                    ++n;
                }
                if (this.counter <= 1) break;
                this.setNewMode(1, 2000);
                this.prepareSpritesAndStuff();
                this.adjustStrings();
                break;
            }
        }
    }

    public void setNewMode(int n, int n2) {
        this.nextMode = n;
        this.gameMode = 0;
        this.modeTime = System.currentTimeMillis() + (long)n2;
    }

    public void keyPressed(int n) {
        if (n == -4) {
            this.owner.exitRequested();
        }
        this.lastKey = n;
    }

    public void keyReleased(int n) {
        this.lastKey = 0;
    }
}

