/*
 * Decompiled with CFR 0.152.
 */
package henson.games;

import com.siemens.mp.game.Light;
import com.siemens.mp.game.MelodyComposer;
import com.siemens.mp.game.Vibrator;
import henson.games.FirstCanvas;
import henson.games.Location;
import henson.games.MainCanvas;
import henson.games.MainList;
import henson.games.MessageForm;
import henson.games.SplashScreen;
import henson.games.State;
import henson.games.TradeCanvas;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class MoscowpolyMIDlet
extends MIDlet {
    public static MoscowpolyMIDlet instance;
    public static final int[][] streetMap;
    public static final int SOUND_BACK = 0;
    public static final int SOUND_CONGRATULATIONS = 1;
    public static final int SOUND_FAIL = 2;
    public static final int SOUND_STEP = 3;
    public static final int SOUND_MSG_RED = 4;
    public static final int SOUND_MSG_YELLOW = 5;
    public static final int SOUND_MSG_GREEN = 6;
    private static MelodyComposer _$201;
    private FirstCanvas _$1658 = new FirstCanvas();
    private MainCanvas _$684 = new MainCanvas();
    private TradeCanvas _$1659 = new TradeCanvas();
    private MessageForm _$1660 = null;
    private Alert _$1661 = null;
    private MainList _$1662 = null;
    public State[] state = new State[2];
    public Vector locations = new Vector();
    public int which = 0;
    public boolean[] flags = new boolean[4];
    private Random _$1663 = new Random(System.currentTimeMillis());
    private long _$1665 = 0L;

    public MoscowpolyMIDlet() {
        this.state[0] = new State("Player");
        this.state[1] = new State("Computer");
        this.flags[3] = true;
        this.flags[2] = true;
        this.flags[1] = true;
        this.flags[0] = true;
        instance = this;
        this.locations.addElement(new Location("GO", 0, 4, 0, 0, 30, 30, -1, -1, -1, -1, -1, -1, -1, -1));
        this.locations.addElement(new Location("Olympic Village", 0x993399, 8, 30, 0, 30, 30, 2, 10, 30, 90, 160, 250, 60, 50));
        this.locations.addElement(new Location("Community Chest", 0, 1, 60, 0, 30, 30, -1, -1, -1, -1, -1, -1, -1, -1));
        this.locations.addElement(new Location("Proletarskaya Av.", 0x993399, 8, 90, 0, 30, 30, 4, 20, 60, 180, 320, 450, 60, 50));
        this.locations.addElement(new Location("Income Tax", 0, 3, 120, 0, 30, 30, -1, -1, -1, -1, -1, -1, -1, -1));
        this.locations.addElement(new Location("North Railways", 0, 9, 150, 0, 30, 30, -1, 25, 50, 100, 200, -1, 200, -1));
        this.locations.addElement(new Location("Semenovskaya St.", 0x99FFFF, 8, 180, 0, 30, 30, 6, 30, 90, 270, 400, 550, 100, 50));
        this.locations.addElement(new Location("Chance", 0, 0, 210, 0, 30, 30, -1, -1, -1, -1, -1, -1, -1, -1));
        this.locations.addElement(new Location("Turgenevskaya Sq.", 0x99FFFF, 8, 240, 0, 30, 30, 6, 30, 90, 270, 400, 550, 100, 50));
        this.locations.addElement(new Location("Teatralnaya Sq.", 0x99FFFF, 8, 270, 0, 30, 30, 8, 40, 100, 300, 450, 600, 120, 50));
        this.locations.addElement(new Location("Jail", 0, 5, 300, 0, 30, 30, -1, -1, -1, -1, -1, -1, -1, -1));
        this.locations.addElement(new Location("Pushkinskaya Sq.", 0xFF99FF, 8, 300, 30, 30, 30, 10, 50, 150, 450, 625, 750, 140, 100));
        this.locations.addElement(new Location("Mosenergo", 0, 10, 300, 60, 30, 30, -1, 4, 10, -1, -1, -1, 150, -1));
        this.locations.addElement(new Location("Begovaya St.", 0xFF99FF, 8, 300, 90, 30, 30, 10, 50, 150, 450, 625, 750, 140, 100));
        this.locations.addElement(new Location("1905th St.", 0xFF99FF, 8, 300, 120, 30, 30, 12, 60, 180, 500, 700, 900, 160, 100));
        this.locations.addElement(new Location("East Railways", 0, 9, 300, 150, 30, 30, -1, 25, 50, 100, 200, -1, 200, -1));
        this.locations.addElement(new Location("Kievskaya Av.", 0xFFCC00, 8, 300, 180, 30, 30, 14, 70, 200, 550, 750, 950, 180, 100));
        this.locations.addElement(new Location("Community Chest", 0, 1, 300, 210, 30, 30, -1, -1, -1, -1, -1, -1, -1, -1));
        this.locations.addElement(new Location("Entuziastov Av.", 0xFFCC00, 8, 300, 240, 30, 30, 14, 70, 200, 550, 750, 950, 180, 100));
        this.locations.addElement(new Location("Andropova Av.", 0xFFCC00, 8, 300, 270, 30, 30, 16, 80, 220, 600, 800, 1000, 200, 100));
        this.locations.addElement(new Location("Free Parking", 0, 7, 300, 300, 30, 30, -1, -1, -1, -1, -1, -1, -1, -1));
        this.locations.addElement(new Location("Maneznaja Sq.", 0xFF0000, 8, 270, 300, 30, 30, 18, 90, 250, 700, 875, 1050, 220, 150));
        this.locations.addElement(new Location("Chance", 0, 0, 240, 300, 30, 30, -1, -1, -1, -1, -1, -1, -1, -1));
        this.locations.addElement(new Location("Red Sq.", 0xFF0000, 8, 210, 300, 30, 30, 18, 90, 250, 700, 875, 1050, 220, 150));
        this.locations.addElement(new Location("Kremlin", 0xFF0000, 8, 180, 300, 30, 30, 20, 100, 300, 750, 925, 1100, 240, 150));
        this.locations.addElement(new Location("South Railways", 0, 9, 150, 300, 30, 30, -1, 25, 50, 100, 200, -1, 200, -1));
        this.locations.addElement(new Location("Mayakovskogo St.", 0xFFFF00, 8, 120, 300, 30, 30, 22, 110, 330, 800, 975, 1150, 260, 150));
        this.locations.addElement(new Location("Kashirskaya Av.", 0xFFFF00, 8, 90, 300, 30, 30, 22, 110, 330, 800, 975, 1150, 260, 150));
        this.locations.addElement(new Location("Mosvodokanal", 0, 10, 60, 300, 30, 30, -1, 4, 10, -1, -1, -1, 150, -1));
        this.locations.addElement(new Location("Rublevskoye Av.", 0xFFFF00, 8, 30, 300, 30, 30, 24, 120, 360, 850, 1025, 1200, 280, 150));
        this.locations.addElement(new Location("Go To Jail", 0, 6, 0, 300, 30, 30, -1, -1, -1, -1, -1, -1, -1, -1));
        this.locations.addElement(new Location("Mira Avenue", 0x33FF33, 8, 0, 270, 30, 30, 26, 130, 390, 900, 1100, 1275, 300, 200));
        this.locations.addElement(new Location("Leningradskaya Av.", 0x33FF33, 8, 0, 240, 30, 30, 26, 130, 390, 900, 1100, 1275, 300, 200));
        this.locations.addElement(new Location("Community Chest", 0, 1, 0, 210, 30, 30, -1, -1, -1, -1, -1, -1, -1, -1));
        this.locations.addElement(new Location("Leninskaya Av.", 0x33FF33, 8, 0, 180, 30, 30, 28, 150, 450, 1000, 1200, 1400, 320, 200));
        this.locations.addElement(new Location("West Railways", 0, 9, 0, 150, 30, 30, -1, 25, 50, 100, 200, -1, 200, -1));
        this.locations.addElement(new Location("Chance", 0, 0, 0, 120, 30, 30, -1, -1, -1, -1, -1, -1, -1, -1));
        this.locations.addElement(new Location("Tverskaja St.", 0x3333FF, 8, 0, 90, 30, 30, 35, 175, 500, 1100, 1300, 1500, 350, 200));
        this.locations.addElement(new Location("Luxury Tax", 0, 2, 0, 60, 30, 30, -1, -1, -1, -1, -1, -1, -1, -1));
        this.locations.addElement(new Location("Arbat", 0x3333FF, 8, 0, 30, 30, 30, 50, 200, 600, 1400, 1700, 2000, 400, 200));
    }

    public void startApp() {
        new SplashScreen(Display.getDisplay((MIDlet)this), (Displayable)this._$1658);
        this.OpenGame(null);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
        if (_$201 != null) {
            _$201.resetMelody();
        }
    }

    public static void quitApp() {
        instance.destroyApp(true);
        instance.notifyDestroyed();
        instance = null;
    }

    public void ShowMessageBox(String title, String message) {
        this._$1660 = new MessageForm(title, message);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this._$1660);
        if (this.flags[1]) {
            Vibrator.triggerVibrator((int)500);
        }
    }

    public void Congratulions() {
        this._$1658.soundType = 1;
        this._$1661 = new Alert("Congratulations!", String.valueOf(String.valueOf(new StringBuffer("You are winner!!! Duration=").append(this._$1678()).append(" Worth=").append(this.CalcWorth(0)).append("$"))), null, AlertType.ALARM);
        this._$1661.setTimeout(-2);
        Display.getDisplay((MIDlet)this).setCurrent(this._$1661, (Displayable)this._$1658);
        if (this.flags[1]) {
            Vibrator.triggerVibrator((int)2000);
        }
    }

    public void Loose() {
        this._$1658.soundType = 2;
        this._$1661 = new Alert("Ooooops!", String.valueOf(String.valueOf(new StringBuffer("You loose your chance! Your opponent win. Duration=").append(this._$1678()).append(" Worth=ZERO"))), null, AlertType.ALARM);
        this._$1661.setTimeout(-2);
        Display.getDisplay((MIDlet)this).setCurrent(this._$1661, (Displayable)this._$1658);
        if (this.flags[1]) {
            Vibrator.triggerVibrator((int)1000);
        }
    }

    public void ShowInfoBox(String title, String message, boolean modal, AlertType at, Displayable d) {
        this._$1661 = new Alert(title, message, null, at);
        if (modal) {
            this._$1661.setTimeout(-2);
        }
        if (d == null) {
            d = this._$684;
        }
        Display.getDisplay((MIDlet)this).setCurrent(this._$1661, d);
    }

    public void ShowTradeCanvas() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this._$1659);
    }

    public void ShowMainCanvas(int state) {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this._$684);
        switch (state) {
            case -1: {
                break;
            }
            default: {
                this._$684.ProcessForm(state);
            }
        }
    }

    public void ShowMainList(String name, Vector v, int type) {
        this._$1662 = new MainList(name, 3);
        this._$1662.UpdateList(v, type);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this._$1662);
    }

    public void NewGame() {
        int i;
        this._$1665 = System.currentTimeMillis();
        this.which = this.nextRand(2);
        this._$684.init();
        for (i = 0; i < this.state.length; ++i) {
            this.state[i].init();
        }
        for (i = 0; i < this.locations.size(); ++i) {
            Location loc = (Location)this.locations.elementAt(i);
            if (loc == null) continue;
            loc.init();
        }
        if (_$201 != null) {
            _$201.resetMelody();
        }
        this.state[1].computer = true;
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this._$684);
        this._$684.showModelessBox(String.valueOf(String.valueOf(new StringBuffer("All players rolled the dice and ").append(this.state[this.which].name).append(" rolled the highest total. Therefore ").append(this.state[this.which].name).append(" goes first."))), 1);
        this._$684.startComputerTimer();
    }

    public void OpenGame(String name) {
        try {
            RecordStore r = null;
            r = name == null ? RecordStore.openRecordStore((String)"_Common", (boolean)true) : RecordStore.openRecordStore((String)name, (boolean)true);
            byte[] data = r.getRecord(1);
            if (data != null) {
                ByteArrayInputStream bin = new ByteArrayInputStream(data);
                DataInputStream din = new DataInputStream(bin);
                try {
                    if (name == null) {
                        for (int i = 0; i < 4; ++i) {
                            this.flags[i] = din.readBoolean();
                        }
                        this.ProcessFlags();
                    } else {
                        int i;
                        this.which = din.readInt();
                        long duration = din.readLong();
                        this._$1665 = System.currentTimeMillis() - duration;
                        for (i = 0; i < this.state.length; ++i) {
                            this.state[i].serialize(din);
                        }
                        for (i = 0; i < this.locations.size(); ++i) {
                            Location loc = (Location)this.locations.elementAt(i);
                            loc.serialize(din);
                        }
                    }
                }
                catch (IOException e) {
                    System.out.println(e);
                }
            }
            r.closeRecordStore();
            if (name != null) {
                this.Continue();
            }
        }
        catch (RecordStoreNotFoundException e) {
            System.out.println((Object)e);
        }
        catch (RecordStoreFullException e) {
            System.out.println((Object)e);
        }
        catch (RecordStoreException e) {
            System.out.println((Object)e);
        }
    }

    public boolean SaveGame(String name) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        try {
            RecordStore r = null;
            r = name == null ? RecordStore.openRecordStore((String)"_Common", (boolean)true) : RecordStore.openRecordStore((String)name, (boolean)true);
            if (name == null) {
                for (int i = 0; i < 4; ++i) {
                    dout.writeBoolean(this.flags[i]);
                }
            } else {
                int i;
                dout.writeInt(this.which);
                long duration = System.currentTimeMillis() - this._$1665;
                dout.writeLong(duration);
                for (i = 0; i < this.state.length; ++i) {
                    this.state[i].serialize(dout);
                }
                for (i = 0; i < this.locations.size(); ++i) {
                    Location loc = (Location)this.locations.elementAt(i);
                    loc.serialize(dout);
                }
            }
            if (r.getNumRecords() > 0) {
                r.setRecord(1, bout.toByteArray(), 0, bout.size());
            } else {
                r.addRecord(bout.toByteArray(), 0, bout.size());
            }
            r.closeRecordStore();
            if (name != null) {
                this.Continue();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println(e);
            boolean bl = false;
            return bl;
        }
    }

    public void Continue() {
        if (_$201 != null) {
            _$201.resetMelody();
        }
        this._$684.startComputerTimer();
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this._$684);
    }

    public void ShowMenu(boolean isContinue) {
        this._$684.stopComputerTimer();
        System.gc();
        if (isContinue) {
            this._$1658.startMenu = 2;
            this._$1658.selMenu = 3;
        }
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this._$1658);
    }

    public Vector BuildHouseList(boolean buy) {
        Vector<Integer> v = new Vector<Integer>();
        int which = MoscowpolyMIDlet.instance.which;
        int cash = this.state[which].cash;
        for (int i = 0; i < streetMap.length; ++i) {
            Location loc;
            int j;
            boolean success = true;
            int minValue = 10;
            int maxValue = 0;
            for (j = 0; j < streetMap[i].length; ++j) {
                loc = this._$684.GetLoc(streetMap[i][j]);
                if (loc.owner != which) {
                    success = false;
                    break;
                }
                if (buy) {
                    minValue = Math.min(minValue, loc.level);
                    continue;
                }
                maxValue = Math.max(maxValue, loc.level);
            }
            if (!success) continue;
            for (j = 0; j < streetMap[i].length; ++j) {
                loc = (Location)this.locations.elementAt(streetMap[i][j]);
                if (buy) {
                    if (loc.level != minValue || minValue >= 5 || cash < loc.priceHouse) continue;
                    v.addElement(new Integer(streetMap[i][j]));
                    continue;
                }
                if (loc.level != maxValue || maxValue <= 0) continue;
                v.addElement(new Integer(streetMap[i][j]));
            }
        }
        return v;
    }

    public Vector BuildMortgageList(boolean mortgage) {
        Vector<Integer> v = new Vector<Integer>();
        int which = MoscowpolyMIDlet.instance.which;
        int cash = MoscowpolyMIDlet.instance.state[which].cash;
        int[][] map = new int[][]{{1, 3}, {6, 8, 9}, {11, 13, 14}, {16, 18, 19}, {21, 23, 24}, {26, 27, 29}, {31, 32, 34}, {37, 39}};
        for (int i = 0; i < map.length; ++i) {
            for (int j = 0; j < map[i].length; ++j) {
                Location loc = (Location)this.locations.elementAt(map[i][j]);
                if (mortgage) {
                    if (loc.owner != which || loc.level != 0 || loc.mortgaged) continue;
                    v.addElement(new Integer(map[i][j]));
                    continue;
                }
                int cost = loc.price >> 1;
                cost += cost / 10;
                if (loc.owner != which || !loc.mortgaged || cash < cost) continue;
                v.addElement(new Integer(map[i][j]));
            }
        }
        return v;
    }

    public Vector BuildOthersList() {
        Vector<Integer> v = new Vector<Integer>();
        int cash = this.state[this.which].cash;
        int[][] map = new int[][]{{5, 15, 25, 35}, {12, 28}, {1, 3}, {6, 8, 9}, {11, 13, 14}, {16, 18, 19}, {21, 23, 24}, {26, 27, 29}, {31, 32, 34}, {37, 39}};
        for (int i = 0; i < map.length; ++i) {
            for (int j = 0; j < map[i].length; ++j) {
                boolean check;
                Location loc = (Location)this.locations.elementAt(map[i][j]);
                boolean bl = check = loc.type == 8 && loc.mortgaged || loc.type != 8 && !loc.mortgaged;
                if (loc.owner != this.which || loc.level != 0 || !check) continue;
                v.addElement(new Integer(map[i][j]));
            }
        }
        return v;
    }

    public boolean CheckFullHouse(Integer pos) {
        int[][] map = new int[][]{{5, 15, 25, 35}, {12, 28}, {1, 3}, {6, 8, 9}, {11, 13, 14}, {16, 18, 19}, {21, 23, 24}, {26, 27, 29}, {31, 32, 34}, {37, 39}};
        for (int i = 0; i < map.length; ++i) {
            boolean fullhouse = true;
            boolean foundlocation = false;
            for (int j = 0; j < map[i].length; ++j) {
                Location l = (Location)this.locations.elementAt(map[i][j]);
                if (l.owner != this.which) {
                    fullhouse = false;
                }
                if (pos != map[i][j]) continue;
                foundlocation = true;
            }
            if (!foundlocation) continue;
            return fullhouse;
        }
        return false;
    }

    public int nextRand(int _l) {
        return (int)((long)Math.abs(this._$1663.nextInt()) * (long)_l >>> 31);
    }

    private String _$1678() {
        long seconds = (System.currentTimeMillis() - this._$1665) / (long)1000;
        long minutes = seconds / (long)60;
        long hours = minutes / (long)60;
        Long min = new Long(minutes - hours * (long)60);
        Long sec = new Long(seconds - minutes * (long)60);
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(hours))).append(":").append(min < 10L ? "0".concat(String.valueOf(String.valueOf(min.toString()))) : min.toString()).append(":").append(sec < 10L ? "0".concat(String.valueOf(String.valueOf(sec.toString()))) : sec.toString())));
    }

    public int CalcWorth(int owner) {
        int worth = 0;
        for (int i = 0; i < this.locations.size(); ++i) {
            Location loc = (Location)this.locations.elementAt(i);
            if (loc.owner != owner) continue;
            if (loc.mortgaged) {
                worth += loc.price >> 1;
                continue;
            }
            worth += loc.price + loc.priceHouse * loc.level;
        }
        return worth;
    }

    public void ProcessFlags() {
        this.SaveGame(null);
        if (this.flags[2]) {
            Light.setLightOn();
        } else {
            Light.setLightOff();
        }
    }

    static {
        streetMap = new int[][]{{1, 3}, {6, 8, 9}, {11, 13, 14}, {16, 18, 19}, {21, 23, 24}, {26, 27, 29}, {31, 32, 34}, {37, 39}};
        SOUND_BACK = 0;
        SOUND_CONGRATULATIONS = 1;
        SOUND_FAIL = 2;
        SOUND_STEP = 3;
        SOUND_MSG_RED = 4;
        SOUND_MSG_YELLOW = 5;
        SOUND_MSG_GREEN = 6;
        _$201 = null;
    }
}

