/*
 * Decompiled with CFR 0.152.
 */
package sarsdoctor;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import sarsdoctor.CImgLib;
import sarsdoctor.GameCanvas;
import sarsdoctor.MainUI;

public class CMainLoop
implements Runnable {
    static Random random = new Random();
    private static final int RUNSTATE_PLAY = 0;
    private static final int RUNSTATE_FALL = 1;
    private static final int RUNSTATE_VICTROY = 2;
    private static final int RUNSTATE_OVER = 3;
    private static final int RUNSTATE_LOADING = 4;
    private static final int RUNSTATE_PREFULLPAINT = 5;
    private static final int RUNSTATE_PAUSE = 6;
    static final int GRID_WIDTH = 7;
    static final int GRID_HEIGHT = 11;
    public int m_nClipX = 0;
    public int m_nClipY = 0;
    public int m_nClipWidth = 0;
    public int m_nClipHeight = 0;
    public CImgLib m_ImgLib;
    public int m_nScrWidth = 0;
    public int m_nScrHeight = 0;
    public boolean m_bQuit = false;
    public boolean m_bPause = false;
    public boolean m_bCanInput = true;
    public boolean m_bShowAlert = false;
    static int m_nDelay = 10;
    public int m_nTileWidth = 11;
    public int m_nTileHeight = 8;
    public MainUI m_UI;
    public GameCanvas m_Canvas;
    public int m_nBkColor = 1726794;
    private int m_nOldState = 0;
    private int m_nRunState = 0;
    private int m_nLevel = 0;
    private byte[] m_Scene = null;
    private boolean m_bMustRepaint = true;
    public int m_nVirualTotal = 0;
    static final int LEVELCOUNT = 1;
    private String m_Msg;
    private long m_lTimer = 0L;
    private int m_nSpeed = 0;
    private int m_nSpeedMax = 60;
    private int m_nX;
    private int m_nY;
    private int m_nOldX;
    private int m_nOldY;
    private boolean m_bCtrlDir = false;
    private boolean m_bPaintCtrl = true;
    private boolean m_bRePaint = true;
    private boolean m_bCreateCtrl = true;
    private byte[] m_byCtrl = new byte[2];
    private byte[] m_byToCtrl = new byte[2];
    private int m_nDestroyXBeg = -1;
    private int m_nDestroyXEnd = -1;
    private int m_nDestroyYBeg = -1;
    private int m_nDestroyYEnd = -1;
    private int[] m_nFallCtrlY = new int[7];
    private int[] m_nFallCtrlY1 = new int[7];
    private int m_nClrBeg = 0;
    private boolean m_bChgClr = false;
    private boolean m_bPaintNext = true;
    private int m_nNextX;
    private int m_nNextY;
    private int m_nScrXOff = 2;
    private int m_nScrYOff = 4;
    private long m_lRunTimer = 0L;
    int m_nScore = 0;
    int m_nTimes = 1;
    private static final byte SCENE_REPAIT = -128;
    private static final byte SCENE_REPAITMASK = 127;
    private static final byte SCENE_VIRAL = 64;
    private static final byte SCENE_POINT01 = 1;
    private static final byte SCENE_POINT02 = 2;
    private static final byte SCENE_POINT03 = 4;
    private static final byte SCENE_POINTMASK = 7;

    public CMainLoop(GameCanvas gameCanvas) {
        this.m_Canvas = gameCanvas;
        this.m_ImgLib = new CImgLib();
        this.m_UI = new MainUI(this);
        this.m_Scene = new byte[77];
        this.m_nClrBeg = 0;
    }

    void startFirst() {
        this.Loading();
        this.m_ImgLib.load("sars.img", this.m_nTileWidth, this.m_nTileHeight);
        this.m_ImgLib.load("killsars.img", this.m_nTileWidth, this.m_nTileHeight);
        this.m_UI.loadImage();
        this.startLevel(0);
    }

    void restart(int n) {
        this.m_nScore = 0;
        this.startLevel(n);
        this.repaint();
    }

    void startLevel(int n) {
        Object var2_2 = null;
        this.Loading();
        this.m_bCanInput = true;
        this.m_nLevel = n;
        this.m_bPaintNext = true;
        this.m_nDestroyXBeg = -1;
        this.m_nDestroyXEnd = -1;
        this.m_nDestroyYBeg = 0;
        this.m_nDestroyYEnd = 0;
        int n2 = 0;
        while (n2 < this.m_nFallCtrlY.length) {
            this.m_nFallCtrlY[n2] = 0;
            ++n2;
        }
        if (!this.m_Canvas.m_bColor) {
            this.m_nBkColor = 0xFFFFFF;
            this.m_nClrBeg = 21;
        }
        this.FirstInitScene(n);
        int n3 = (random.nextInt() >>> 1) % 3;
        switch (n3) {
            case 0: {
                this.m_byToCtrl[0] = 1;
                break;
            }
            case 1: {
                this.m_byToCtrl[0] = 2;
                break;
            }
            case 2: {
                this.m_byToCtrl[0] = 4;
            }
        }
        n3 = (random.nextInt() >>> 1) % 3;
        switch (n3) {
            case 0: {
                this.m_byToCtrl[1] = 1;
                break;
            }
            case 1: {
                this.m_byToCtrl[1] = 2;
                break;
            }
            case 2: {
                this.m_byToCtrl[1] = 4;
            }
        }
        this.m_lRunTimer = System.currentTimeMillis();
        this.m_nRunState = 0;
        this.m_nOldState = 0;
        if (n == 0) {
            this.m_Canvas.RemoveCommand();
            this.m_bMustRepaint = true;
        } else {
            this.SetFullRepaint();
        }
    }

    void restoreState() {
        this.m_nRunState = this.m_nOldState;
    }

    void setState(int n) {
        this.m_nOldState = this.m_nRunState;
        this.m_nRunState = n;
    }

    void SetFullRepaint() {
        this.setState(5);
        this.m_Msg = "Please wait...";
        this.m_Canvas.RemoveCommand();
    }

    void destroy() {
        this.m_bQuit = true;
    }

    void SetGameDelay(int n) {
        m_nDelay = n;
    }

    public void SetScreenRect(int n, int n2) {
        int n3;
        int n4 = 128;
        if (n / 128 > n2 / 96) {
            n3 = n2;
            n4 = 96;
        } else {
            n3 = n;
            n4 = 128;
        }
        this.m_nTimes = n3 > n4 ? n3 / n4 : -n4 / n3;
        this.m_nScrWidth = n3 * 84 / n4;
        this.m_nScrHeight = n3 * 88 / n4;
        this.m_nTileWidth = this.m_nScrWidth / 7;
        this.m_nTileHeight = this.m_nScrHeight / 11;
        this.m_nNextX = n3 * 95 / n4;
        this.m_nNextY = n3 / n4;
        this.m_nScrXOff = n3 * 2 / n4;
        this.m_nScrYOff = n3 * 4 / n4;
        this.m_UI.SetScreenRect(n3, n4);
    }

    void FirstInitScene(int n) {
        boolean bl = false;
        this.m_nVirualTotal = 0;
        try {
            int n2 = 0;
            while (n2 < 77) {
                this.m_Scene[n2] = 0;
                ++n2;
            }
            InputStream inputStream = this.getClass().getResourceAsStream("/data/level." + (n % 1 + 1));
            int n3 = 0;
            int n4 = 0;
            block12: while ((n2 = inputStream.read()) != -1) {
                if (bl) break;
                switch (n2) {
                    case 10: {
                        n3 = 0;
                        if (++n4 < 11) continue block12;
                        bl = true;
                        break;
                    }
                    case 49: {
                        if (n3 < 7) {
                            int n5 = n3 + n4 * 7;
                            this.m_Scene[n5] = (byte)(this.m_Scene[n5] | 1);
                        }
                        ++n3;
                        break;
                    }
                    case 50: {
                        if (n3 < 7) {
                            int n6 = n3 + n4 * 7;
                            this.m_Scene[n6] = (byte)(this.m_Scene[n6] | 2);
                        }
                        ++n3;
                        break;
                    }
                    case 51: {
                        if (n3 < 7) {
                            int n7 = n3 + n4 * 7;
                            this.m_Scene[n7] = (byte)(this.m_Scene[n7] | 2);
                        }
                        ++n3;
                        break;
                    }
                    case 52: {
                        if (n3 < 7) {
                            this.m_Scene[n3 + n4 * 7] = 65;
                            ++this.m_nVirualTotal;
                        }
                        ++n3;
                        break;
                    }
                    case 53: {
                        if (n3 < 7) {
                            this.m_Scene[n3 + n4 * 7] = 66;
                            ++this.m_nVirualTotal;
                        }
                        ++n3;
                        break;
                    }
                    case 54: {
                        if (n3 < 7) {
                            this.m_Scene[n3 + n4 * 7] = 68;
                            ++this.m_nVirualTotal;
                        }
                        ++n3;
                        break;
                    }
                    default: {
                        ++n3;
                    }
                }
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void CreateNewCtrl() {
        this.m_nY = 0;
        this.m_nOldX = this.m_nX = 3;
        this.m_nOldY = this.m_nY;
        this.m_bCtrlDir = false;
        this.m_bChgClr = false;
        this.m_bCanInput = true;
        int n = this.m_nX + (this.m_nY + 1) * 7;
        if ((this.m_Scene[n] & 7) != 0 || (this.m_Scene[n + 1] & 7) != 0) {
            this.Fail("Game Over");
            return;
        }
        this.m_byCtrl[0] = this.m_byToCtrl[0];
        this.m_byCtrl[1] = this.m_byToCtrl[1];
        n = (random.nextInt() >>> 1) % 3;
        switch (n) {
            case 0: {
                this.m_byToCtrl[0] = 1;
                break;
            }
            case 1: {
                this.m_byToCtrl[0] = 2;
                break;
            }
            case 2: {
                this.m_byToCtrl[0] = 4;
            }
        }
        n = (random.nextInt() >>> 1) % 3;
        switch (n) {
            case 0: {
                this.m_byToCtrl[1] = 1;
                break;
            }
            case 1: {
                this.m_byToCtrl[1] = 2;
                break;
            }
            case 2: {
                this.m_byToCtrl[1] = 4;
            }
        }
        n = this.m_nX + this.m_nY * 7;
        this.m_Scene[n] = this.m_byCtrl[0];
        this.m_Scene[n + 1] = this.m_byCtrl[1];
        this.m_bPaintCtrl = true;
        this.m_bPaintNext = true;
    }

    void Victroy() {
        this.m_lTimer = System.currentTimeMillis();
        this.setState(2);
        this.m_Msg = "Victroy!";
        this.repaint();
    }

    void Loading() {
        this.setState(4);
        this.m_Msg = "Please wait...";
        this.repaint();
    }

    void Fail(String string) {
        this.setState(3);
        this.m_Canvas.setState(4);
        this.m_Msg = string;
        this.repaint();
    }

    private void FallStateBegin() {
        int n;
        int n2;
        this.m_bCanInput = false;
        this.setState(1);
        if (this.m_nDestroyXBeg >= 0 && this.m_nDestroyXEnd >= 0) {
            int n3 = this.m_nDestroyXBeg;
            while (n3 <= this.m_nDestroyXEnd) {
                if (this.m_nFallCtrlY[n3] < this.m_nDestroyYEnd) {
                    this.m_nFallCtrlY[n3] = this.m_nDestroyYEnd;
                }
                ++n3;
            }
        }
        int n4 = this.m_nDestroyXBeg - 1;
        int n5 = this.m_nDestroyXBeg;
        int n6 = this.m_nDestroyXBeg;
        boolean bl = false;
        int n7 = this.m_nDestroyYEnd;
        while (n4 >= 0) {
            n2 = n7;
            n = n4 + n2 * 7;
            while (n2 <= this.m_nDestroyYEnd) {
                if ((this.m_Scene[n] & 7) == 0) break;
                if (n2 >= 10 || (this.m_Scene[n + 7] & 7) != 0) {
                    bl = true;
                    break;
                }
                ++n2;
                n += 7;
            }
            if (bl) break;
            n2 = n7;
            n = n4 + n2 * 7;
            while (n2 >= 0 && (this.m_Scene[n] & 0x40) == 64) {
                n -= 7;
                --n2;
            }
            while (n2 >= 0) {
                if ((this.m_Scene[n] & 7) != 0) break;
                n -= 7;
                --n2;
            }
            if (n2 <= 0) break;
            this.m_nFallCtrlY1[n4] = n2;
            n5 = n4--;
            n7 = n2;
        }
        n4 = n5;
        while (n4 < this.m_nDestroyXBeg) {
            this.m_nFallCtrlY[n4] = this.m_nFallCtrlY1[n4];
            ++n4;
        }
        n4 = this.m_nDestroyXEnd + 1;
        n5 = this.m_nDestroyXEnd;
        n6 = this.m_nDestroyXEnd;
        bl = false;
        n7 = this.m_nDestroyYEnd;
        while (n4 < 7) {
            n2 = n7;
            n = n4 + n2 * 7;
            while (n2 <= this.m_nDestroyYEnd) {
                if ((this.m_Scene[n] & 7) == 0) break;
                if (n2 >= 10 || (this.m_Scene[n + 7] & 7) != 0) {
                    bl = true;
                    break;
                }
                ++n2;
                n += 7;
            }
            if (bl) break;
            n2 = n7;
            n = n4 + n2 * 7;
            while (n2 >= 0 && (this.m_Scene[n] & 0x40) == 64) {
                n -= 7;
                --n2;
            }
            while (n2 >= 0) {
                if ((this.m_Scene[n] & 7) != 0) break;
                n -= 7;
                --n2;
            }
            if (n2 <= 0) break;
            this.m_nFallCtrlY1[n4] = n2;
            n6 = n4++;
            n7 = n2;
        }
        n4 = this.m_nDestroyXEnd + 1;
        while (n4 <= n6) {
            this.m_nFallCtrlY[n4] = this.m_nFallCtrlY1[n4];
            ++n4;
        }
        this.m_bRePaint = true;
    }

    boolean subVirualCount() {
        --this.m_nVirualTotal;
        if (this.m_nVirualTotal <= 0) {
            this.Victroy();
            return true;
        }
        return false;
    }

    boolean CheckDestroyLine() {
        byte by;
        int n = 1;
        int n2 = this.m_nX + 7 * this.m_nY;
        byte by2 = this.m_byCtrl[0];
        int n3 = this.m_nX - 1;
        int n4 = n2 - 1;
        while (n3 >= 0) {
            by = (byte)(this.m_Scene[n4] & 7);
            if (by != by2) break;
            ++n;
            --n4;
            --n3;
        }
        int n5 = n3 + 1;
        if (n > 3) {
            this.m_nDestroyXBeg = n5;
            this.m_nDestroyXEnd = this.m_nX;
            this.setState(1);
            this.m_nDestroyYBeg = this.m_nY;
            this.m_nDestroyYEnd = this.m_nY;
        }
        if (by2 != (by = this.m_byCtrl[1])) {
            n5 = this.m_nX + 1;
            n = 0;
        }
        ++n;
        n3 = this.m_nX + 2;
        n4 = n2 + 2;
        while (n3 < 7) {
            by2 = (byte)(this.m_Scene[n4] & 7);
            if (by != by2) break;
            ++n;
            ++n4;
            ++n3;
        }
        int n6 = n3 - 1;
        if (n > 3) {
            this.m_nDestroyXBeg = n5;
            this.m_nDestroyXEnd = n6;
            this.setState(1);
            this.m_nDestroyYBeg = this.m_nY;
            this.m_nDestroyYEnd = this.m_nY;
        }
        if (this.m_nDestroyXEnd - this.m_nDestroyXBeg >= 3) {
            n2 = this.m_nDestroyXBeg + this.m_nY * 7;
            n4 = this.m_nDestroyXBeg;
            while (n4 <= this.m_nDestroyXEnd) {
                if ((this.m_Scene[n2] & 0x40) == 64 && this.subVirualCount()) {
                    return true;
                }
                this.m_Scene[n2] = -128;
                ++n2;
                ++n4;
            }
        }
        n = 1;
        n3 = this.m_nY + 1;
        n2 = this.m_nX + 7 * this.m_nY;
        by2 = this.m_byCtrl[0];
        n4 = n2 + 7;
        while (n3 < 11) {
            by = (byte)(this.m_Scene[n4] & 7);
            if (by != by2) break;
            ++n;
            ++n3;
            n4 += 7;
        }
        n6 = n3 - 1;
        n5 = this.m_nY;
        n3 = this.m_nY - 1;
        n4 = n2 - 7;
        while (n3 >= 0) {
            by = (byte)(this.m_Scene[n4] & 7);
            if (by != by2) break;
            ++n;
            --n3;
            n4 -= 7;
        }
        n5 = n3 + 1;
        if (n > 3) {
            this.setState(1);
            n2 = this.m_nX + 7 * n5;
            n4 = 0;
            while (n4 < n) {
                if ((this.m_Scene[n2] & 0x40) == 64 && this.subVirualCount()) {
                    return true;
                }
                this.m_Scene[n2] = -128;
                n2 += 7;
                ++n4;
            }
            if (this.m_nDestroyXBeg > this.m_nX || this.m_nDestroyXBeg < 0) {
                this.m_nDestroyXBeg = this.m_nX;
            }
            if (this.m_nDestroyXEnd < this.m_nX + 1 || this.m_nDestroyXEnd < 0) {
                this.m_nDestroyXEnd = this.m_nX + 1;
            }
            if (this.m_nDestroyYBeg < 1 || this.m_nDestroyYBeg > n5) {
                this.m_nDestroyYBeg = n5;
            }
            if (this.m_nDestroyYEnd < 1 || this.m_nDestroyYEnd < n6) {
                this.m_nDestroyYEnd = n6;
            }
        }
        n = 1;
        n3 = this.m_nY + 1;
        n2 = this.m_nX + 7 * this.m_nY + 1;
        by2 = this.m_byCtrl[1];
        n4 = n2 + 7;
        while (n3 < 11) {
            by = (byte)(this.m_Scene[n4] & 7);
            if (by != by2) break;
            ++n;
            ++n3;
            n4 += 7;
        }
        n6 = n3 - 1;
        n5 = this.m_nY;
        n3 = this.m_nY - 1;
        n4 = n2 - 7;
        while (n3 >= 0) {
            by = (byte)(this.m_Scene[n4] & 7);
            if (by != by2) break;
            ++n;
            --n3;
            n4 -= 7;
        }
        n5 = n3 + 1;
        if (n > 3) {
            this.setState(1);
            n2 = this.m_nX + 7 * n5 + 1;
            n4 = 0;
            while (n4 < n) {
                if ((this.m_Scene[n2] & 0x40) == 64 && this.subVirualCount()) {
                    return true;
                }
                this.m_Scene[n2] = -128;
                n2 += 7;
                ++n4;
            }
            if (this.m_nDestroyXBeg < 0 || this.m_nDestroyXBeg > this.m_nX) {
                this.m_nDestroyXBeg = this.m_nX;
            }
            if (this.m_nDestroyXEnd < 0 || this.m_nDestroyXEnd < this.m_nX + 1) {
                this.m_nDestroyXEnd = this.m_nX + 1;
            }
            if (this.m_nDestroyYBeg < 1 || this.m_nDestroyYBeg > n5) {
                this.m_nDestroyYBeg = n5;
            }
            if (this.m_nDestroyYEnd < 1 || this.m_nDestroyYEnd < n6) {
                this.m_nDestroyYEnd = n6;
            }
        }
        if (this.m_nRunState == 1) {
            this.FallStateBegin();
        }
        return true;
    }

    boolean CheckDestroyRow() {
        byte by;
        int n = this.m_nX + this.m_nY * 7;
        byte by2 = this.m_byCtrl[1];
        int n2 = 1;
        int n3 = this.m_nY - 2;
        int n4 = n - 14;
        while (n3 >= 0) {
            by = (byte)(this.m_Scene[n4] & 7);
            if (by != by2) break;
            ++n2;
            n4 -= 7;
            --n3;
        }
        int n5 = n3 + 1;
        int n6 = this.m_nY - 1;
        if (n2 > 3) {
            this.setState(1);
            this.m_nDestroyYBeg = n5;
            this.m_nDestroyYEnd = n6;
            this.m_nDestroyXBeg = this.m_nX;
            this.m_nDestroyXEnd = this.m_nX;
        }
        if (this.m_byCtrl[0] != this.m_byCtrl[1]) {
            if (n2 < 4) {
                n5 = this.m_nY;
            }
            n2 = 0;
        }
        ++n2;
        by2 = this.m_byCtrl[0];
        n3 = this.m_nY + 1;
        n4 = n + 7;
        while (n3 < 11) {
            by = (byte)(this.m_Scene[n4] & 7);
            if (by != by2) break;
            ++n2;
            n4 += 7;
            ++n3;
        }
        n6 = n3 - 1;
        if (n2 > 3) {
            this.setState(1);
            this.m_nDestroyYBeg = n5;
            this.m_nDestroyYEnd = n6;
            this.m_nDestroyXBeg = this.m_nX;
            this.m_nDestroyXEnd = this.m_nX;
        }
        if (this.m_nDestroyYEnd - this.m_nDestroyYBeg > 2) {
            n4 = this.m_nX + this.m_nDestroyYBeg * 7;
            n3 = this.m_nDestroyYBeg;
            while (n3 <= this.m_nDestroyYEnd) {
                if ((this.m_Scene[n4] & 0x40) == 64 && this.subVirualCount()) {
                    return true;
                }
                this.m_Scene[n4] = -128;
                n4 += 7;
                ++n3;
            }
        }
        int n7 = 0;
        while (n7 < 2) {
            if (this.m_nY - n7 < 0) break;
            n = this.m_nX + (this.m_nY - n7) * 7;
            n2 = 1;
            by2 = this.m_byCtrl[n7];
            n4 = n - 1;
            n3 = this.m_nX - 1;
            while (n3 >= 0) {
                by = (byte)(this.m_Scene[n4] & 7);
                if (by != by2) break;
                ++n2;
                --n4;
                --n3;
            }
            n5 = n3 + 1;
            n6 = this.m_nX;
            n4 = n + 1;
            n3 = this.m_nX + 1;
            while (n3 < 7) {
                by = (byte)(this.m_Scene[n4] & 7);
                if (by != by2) break;
                ++n2;
                ++n4;
                ++n3;
            }
            n6 = n3 - 1;
            if (n2 > 3) {
                this.setState(1);
                this.m_nDestroyXBeg = n5;
                this.m_nDestroyXEnd = n6;
                if (this.m_nDestroyYBeg < 1 || this.m_nDestroyYBeg > this.m_nY - n7) {
                    this.m_nDestroyYBeg = this.m_nY - n7;
                }
                if (this.m_nDestroyYEnd < 1 || this.m_nDestroyYEnd < this.m_nY) {
                    this.m_nDestroyYEnd = this.m_nY;
                }
                n4 = (this.m_nY - n7) * 7 + n5;
                n3 = n5;
                while (n3 <= n6) {
                    if ((this.m_Scene[n4] & 0x40) == 64 && this.subVirualCount()) {
                        return true;
                    }
                    this.m_Scene[n4] = -128;
                    ++n4;
                    ++n3;
                }
            }
            ++n7;
        }
        if (this.m_nRunState == 1) {
            this.FallStateBegin();
        }
        return true;
    }

    void ReBegin() {
        this.m_byCtrl[0] = this.m_byToCtrl[0];
        this.m_byCtrl[1] = this.m_byToCtrl[1];
        this.m_bCreateCtrl = true;
    }

    void ProcessCtrl() {
        ++this.m_nSpeed;
        if (this.m_nSpeed < this.m_nSpeedMax) {
            return;
        }
        this.m_nSpeed = 0;
        if (this.m_bCreateCtrl) {
            this.CreateNewCtrl();
            this.m_bCreateCtrl = false;
            return;
        }
        if (this.m_bCtrlDir) {
            boolean bl = false;
            int n = this.m_nX + this.m_nY * 7;
            if (this.m_nY < 10) {
                int n2 = this.m_Scene[n + 7] & 7;
                if (n2 != 0) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (bl) {
                this.m_bCanInput = false;
                this.CheckDestroyRow();
                this.ReBegin();
            } else {
                this.m_bPaintCtrl = true;
                ++this.m_nY;
                n = this.m_nX + this.m_nY * 7;
                this.m_Scene[n - 14] = 0;
                this.m_Scene[n - 7] = this.m_byCtrl[1];
                this.m_Scene[n] = this.m_byCtrl[0];
            }
        } else {
            boolean bl = false;
            int n = this.m_nX + this.m_nY * 7;
            if (this.m_nY < 10) {
                n += 7;
                int n3 = 0;
                while (n3 < 2) {
                    int n4 = this.m_Scene[n + n3] & 7;
                    if (n4 != 0) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
            } else {
                bl = true;
            }
            if (bl) {
                this.m_bCanInput = false;
                this.CheckDestroyLine();
                this.ReBegin();
            } else {
                this.m_bPaintCtrl = true;
                ++this.m_nY;
                n = this.m_nX + this.m_nY * 7;
                this.m_Scene[n - 7] = 0;
                this.m_Scene[n - 7 + 1] = 0;
                this.m_Scene[n] = this.m_byCtrl[0];
                this.m_Scene[n + 1] = this.m_byCtrl[1];
            }
        }
    }

    boolean CheckDestroy(int n, int n2) {
        byte by;
        if (n < 0 || n >= 7) {
            return false;
        }
        if (n2 < 0 || n2 >= 11) {
            return false;
        }
        int n3 = n;
        int n4 = n2;
        int n5 = n + n2 * 7;
        int n6 = 1;
        byte by2 = (byte)(this.m_Scene[n5] & 7);
        n3 = n - 1;
        int n7 = n5 - 1;
        while (n3 >= 0) {
            by = (byte)(this.m_Scene[n7] & 7);
            if (by != by2) break;
            ++n6;
            --n7;
            --n3;
        }
        int n8 = n3 + 1;
        n3 = n + 1;
        n7 = n5 + 1;
        while (n3 < 7) {
            by = (byte)(this.m_Scene[n7] & 7);
            if (by != by2) break;
            ++n6;
            ++n7;
            ++n3;
        }
        int n9 = n3 - 1;
        if (n6 > 3) {
            if (this.m_nDestroyXBeg < 0 || this.m_nDestroyXBeg > n8) {
                this.m_nDestroyXBeg = n8;
            }
            if (this.m_nDestroyXEnd < 0 || this.m_nDestroyXEnd < n9) {
                this.m_nDestroyXEnd = n9;
            }
            this.setState(1);
            if (this.m_nDestroyYBeg < 1 || this.m_nDestroyYBeg > n2) {
                this.m_nDestroyYBeg = n2;
            }
            if (this.m_nDestroyYEnd < 1 || this.m_nDestroyYEnd < n2) {
                this.m_nDestroyYEnd = n2;
            }
            n5 = n8 + n2 * 7;
            n7 = n8;
            while (n7 <= n9) {
                if ((this.m_Scene[n5] & 0x40) == 64 && this.subVirualCount()) {
                    return true;
                }
                this.m_Scene[n5] = -128;
                ++n5;
                ++n7;
            }
        }
        n6 = 1;
        n9 = n2;
        n8 = n2;
        n5 = n + 7 * n2;
        if (n2 < 10) {
            n3 = n2 + 1;
            n7 = n5 + 7;
            while (n3 < 11) {
                by = (byte)(this.m_Scene[n7] & 7);
                if (by != by2) break;
                ++n6;
                ++n3;
                n7 += 7;
            }
            n9 = n3 - 1;
            n8 = n2;
        }
        if (n2 > 0) {
            n3 = n2 - 1;
            n7 = n5 - 7;
            while (n3 >= 0) {
                by = (byte)(this.m_Scene[n7] & 7);
                if (by != by2) break;
                ++n6;
                --n3;
                n7 -= 7;
            }
            n8 = n3 + 1;
        }
        if (n6 > 3) {
            this.setState(1);
            n5 = n + 7 * n8;
            n7 = n8;
            while (n7 <= n9) {
                if ((this.m_Scene[n5] & 0x40) == 64 && this.subVirualCount()) {
                    return true;
                }
                this.m_Scene[n5] = -128;
                n5 += 7;
                ++n7;
            }
            if (this.m_nDestroyYBeg < 1 || this.m_nDestroyYBeg > n8) {
                this.m_nDestroyYBeg = n8;
            }
            if (this.m_nDestroyYEnd < 1 || this.m_nDestroyYEnd < n9) {
                this.m_nDestroyYEnd = n9;
            }
            if (this.m_nDestroyXBeg < 0 || this.m_nDestroyXBeg > n) {
                this.m_nDestroyXBeg = n;
            }
            if (this.m_nDestroyXEnd < 0 || this.m_nDestroyXEnd < n) {
                this.m_nDestroyXEnd = n;
            }
        }
        if (this.m_nRunState == 1) {
            this.FallStateBegin();
        }
        return false;
    }

    void RunFall() {
        boolean bl = true;
        boolean bl2 = false;
        ++this.m_nSpeed;
        if (this.m_nSpeed < this.m_nSpeedMax / 4) {
            return;
        }
        int n = 0;
        while (n < 7) {
            if (this.m_nFallCtrlY[n] > 10) {
                this.m_nFallCtrlY[n] = 0;
            }
            if (this.m_nFallCtrlY[n] > 0) {
                int n2 = this.m_nFallCtrlY[n];
                int n3 = n + n2 * 7;
                while (n2 >= 0) {
                    int n4 = this.m_Scene[n3] & 7;
                    if (n4 == 0 || (this.m_Scene[n3] & 0x40) == 64) {
                        if (this.m_nFallCtrlY[n] == n2) {
                            int n5 = n;
                            this.m_nFallCtrlY[n5] = this.m_nFallCtrlY[n5] - 1;
                        }
                        --n2;
                        n3 -= 7;
                        continue;
                    }
                    bl2 = false;
                    if (n2 < 10) {
                        n4 = this.m_Scene[n3 + 7] & 7;
                        if (n4 != 0 || (this.m_Scene[n3 + 7] & 0x40) == 64) {
                            bl2 = true;
                        }
                    } else {
                        bl2 = true;
                    }
                    if (bl2) {
                        if (this.m_nFallCtrlY[n] == n2) {
                            int n6 = n;
                            this.m_nFallCtrlY[n6] = this.m_nFallCtrlY[n6] - 1;
                        }
                        this.CheckDestroy(n, n2);
                    } else {
                        if (this.m_nFallCtrlY[n] == n2) {
                            int n7 = n;
                            this.m_nFallCtrlY[n7] = this.m_nFallCtrlY[n7] + 1;
                        }
                        bl = false;
                        this.m_Scene[n3 + 7] = (byte)(this.m_Scene[n3] | 0xFFFFFF80);
                        this.m_Scene[n3] = -128;
                    }
                    --n2;
                    n3 -= 7;
                }
            }
            ++n;
        }
        if (bl) {
            this.m_nDestroyXBeg = -1;
            this.m_nDestroyXEnd = -1;
            this.m_nDestroyYBeg = 0;
            this.m_nDestroyYEnd = 0;
            this.setState(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.m_bQuit) {
            long l = System.currentTimeMillis();
            if (l - this.m_lRunTimer > 300000L) {
                this.Fail("Sorry ,This is a Demo!");
                continue;
            }
            if (this.m_bPause) continue;
            if (this.m_nRunState == 0) {
                CMainLoop cMainLoop = this;
                synchronized (cMainLoop) {
                    if (!this.m_bMustRepaint) {
                        this.ProcessCtrl();
                    }
                    if (this.m_bShowAlert) {
                        this.ShowAlert(AlertType.WARNING);
                        this.m_bShowAlert = false;
                    }
                }
                try {
                    Thread.sleep(m_nDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.repaint();
                continue;
            }
            if (1 == this.m_nRunState) {
                this.RunFall();
                continue;
            }
            if (2 != this.m_nRunState) continue;
            if (l - this.m_lTimer > 3000L) {
                this.setState(0);
                ++this.m_nLevel;
                this.startLevel(this.m_nLevel);
            }
            this.repaint();
        }
    }

    void ShowAlert(AlertType alertType) {
        Display display = this.m_Canvas.getDisplay();
        alertType.playSound(display);
    }

    void pause() {
        this.m_bPause = true;
        this.setState(6);
        this.m_Msg = "Pause";
    }

    void resume() {
        this.restoreState();
        this.m_bPause = false;
        this.SetFullRepaint();
        this.repaint();
    }

    public void repaint(int n, int n2, int n3, int n4) {
        if (n < 0 || n2 < 0 || n > this.m_nScrWidth || n2 > this.m_nScrHeight) {
            return;
        }
        this.m_Canvas.repaint(n, n2, n3, n4);
    }

    public void repaint() {
        this.m_Canvas.repaint();
    }

    void PaintScene(Graphics graphics, boolean bl) {
        byte by;
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        if (bl) {
            this.m_bRePaint = false;
            int n5 = 0;
            while (n5 < 11) {
                int n6 = 0;
                while (n6 < 7) {
                    byte by2 = (byte)(this.m_Scene[n3] & 7);
                    if (by2 != 0) {
                        switch (by2) {
                            case 1: {
                                n4 = 0;
                                break;
                            }
                            case 2: {
                                n4 = 1;
                                break;
                            }
                            case 4: {
                                n4 = 2;
                            }
                        }
                        if ((this.m_Scene[n3] & 0x40) == 64) {
                            this.m_ImgLib.paint(graphics, 0, n6 * this.m_nTileWidth, n5 * this.m_nTileHeight, 0, this.m_nTimes, n4 * 7 + this.m_nClrBeg);
                        } else {
                            this.m_ImgLib.paint(graphics, 1, n6 * this.m_nTileWidth, n5 * this.m_nTileHeight, 0, this.m_nTimes, n4 * 7 + this.m_nClrBeg);
                        }
                    }
                    int n7 = n3++;
                    this.m_Scene[n7] = (byte)(this.m_Scene[n7] & 0x7F);
                    ++n6;
                }
                ++n5;
            }
            return;
        }
        if (this.m_bPaintCtrl) {
            this.m_bPaintCtrl = false;
            n2 = this.m_nOldY;
            while (n2 >= this.m_nOldY - 2) {
                if (n2 >= 0) {
                    n3 = n2 * 7;
                    n = this.m_nOldX - 1;
                    while (n <= this.m_nOldX + 2) {
                        if (n < 7 && n >= 0 && (this.m_Scene[n3 + n] & 7) == 0) {
                            graphics.setColor(this.m_nBkColor);
                            this.m_ImgLib.Clear(graphics, 0, n * this.m_nTileWidth, n2 * this.m_nTileHeight, this.m_nTimes);
                        }
                        ++n;
                    }
                }
                --n2;
            }
            by = this.m_byCtrl[0];
            if (by != 0) {
                switch (by) {
                    case 1: {
                        n4 = 0;
                        break;
                    }
                    case 2: {
                        n4 = 1;
                        break;
                    }
                    case 4: {
                        n4 = 2;
                    }
                }
                this.m_ImgLib.paint(graphics, 1, this.m_nX * this.m_nTileWidth, this.m_nY * this.m_nTileHeight, 0, this.m_nTimes, n4 * 7 + this.m_nClrBeg);
            }
            if ((by = this.m_byCtrl[1]) != 0) {
                switch (by) {
                    case 1: {
                        n4 = 0;
                        break;
                    }
                    case 2: {
                        n4 = 1;
                        break;
                    }
                    case 4: {
                        n4 = 2;
                    }
                }
                if (this.m_bCtrlDir) {
                    this.m_ImgLib.paint(graphics, 1, this.m_nX * this.m_nTileWidth, (this.m_nY - 1) * this.m_nTileHeight, 0, this.m_nTimes, n4 * 7 + this.m_nClrBeg);
                } else {
                    this.m_ImgLib.paint(graphics, 1, (this.m_nX + 1) * this.m_nTileWidth, this.m_nY * this.m_nTileHeight, 0, this.m_nTimes, n4 * 7 + this.m_nClrBeg);
                }
            }
            this.m_nOldX = this.m_nX;
            this.m_nOldY = this.m_nY;
        }
        if (this.m_bRePaint) {
            this.m_bRePaint = false;
            n2 = 0;
            while (n2 < 11) {
                n = 0;
                while (n < 7) {
                    if ((this.m_Scene[n3] & 0xFFFFFF80) == -128) {
                        by = (byte)(this.m_Scene[n3] & 7);
                        if (by != 0) {
                            switch (by) {
                                case 1: {
                                    n4 = 0;
                                    break;
                                }
                                case 2: {
                                    n4 = 1;
                                    break;
                                }
                                case 4: {
                                    n4 = 2;
                                }
                            }
                            if ((this.m_Scene[n3] & 0x40) == 64) {
                                this.m_ImgLib.paint(graphics, 0, n * this.m_nTileWidth, n2 * this.m_nTileHeight, 0, this.m_nTimes, n4 * 7 + this.m_nClrBeg);
                            } else {
                                this.m_ImgLib.paint(graphics, 1, n * this.m_nTileWidth, n2 * this.m_nTileHeight, 0, this.m_nTimes, n4 * 7 + this.m_nClrBeg);
                            }
                        } else {
                            graphics.setColor(this.m_nBkColor);
                            this.m_ImgLib.Clear(graphics, 0, n * this.m_nTileWidth, n2 * this.m_nTileHeight, this.m_nTimes);
                        }
                        int n8 = n3;
                        this.m_Scene[n8] = (byte)(this.m_Scene[n8] & 0x7F);
                    }
                    ++n3;
                    ++n;
                }
                ++n2;
            }
        }
    }

    void PaintMsg(Graphics graphics) {
        Font font = graphics.getFont();
        int n = font.getHeight();
        int n2 = font.stringWidth(this.m_Msg);
        graphics.setColor(0xFFFFFF);
        graphics.fillRect((this.m_nClipWidth - n2) / 2 - 1, (this.m_nClipHeight - n) / 2, n2 + 2, n);
        graphics.setColor(0xFF0000);
        graphics.setFont(font);
        graphics.drawString(this.m_Msg, (this.m_nClipWidth - n2) / 2, (this.m_nClipHeight - n) / 2, 0x10 | 4);
    }

    public void paint(Graphics graphics) {
        int n = 0;
        long l = System.currentTimeMillis();
        if (4 == this.m_nRunState) {
            this.m_nClipX = graphics.getClipX();
            this.m_nClipY = graphics.getClipY();
            this.m_nClipWidth = graphics.getClipWidth();
            this.m_nClipHeight = graphics.getClipHeight();
            graphics.setColor(0x7F7F7F);
            graphics.fillRect(this.m_nClipX, this.m_nClipY, this.m_nClipWidth, this.m_nClipHeight);
            this.PaintMsg(graphics);
        } else {
            if (6 == this.m_nRunState) {
                this.PaintMsg(graphics);
                return;
            }
            if (5 == this.m_nRunState) {
                this.m_bMustRepaint = true;
                this.m_nRunState = this.m_nOldState;
                this.m_nClipX = graphics.getClipX();
                this.m_nClipY = graphics.getClipY();
                this.m_nClipWidth = graphics.getClipWidth();
                this.m_nClipHeight = graphics.getClipHeight();
                graphics.setColor(0x7F7F7F);
                graphics.fillRect(this.m_nClipX, this.m_nClipY, this.m_nClipWidth, this.m_nClipHeight);
                this.PaintMsg(graphics);
                return;
            }
            if (this.m_bMustRepaint) {
                this.m_nClipX = graphics.getClipX();
                this.m_nClipY = graphics.getClipY();
                this.m_nClipWidth = graphics.getClipWidth();
                this.m_nClipHeight = graphics.getClipHeight();
                graphics.setColor(0x7F7F7F);
                graphics.fillRect(this.m_nClipX, this.m_nClipY, this.m_nClipWidth, this.m_nClipHeight);
                graphics.setColor(this.m_nBkColor);
                graphics.fillRect(this.m_nScrXOff, this.m_nScrYOff, this.m_nScrWidth, this.m_nScrHeight);
            }
            this.m_UI.paint(graphics, this.m_bMustRepaint, this.m_nTimes);
            if (this.m_bPaintNext || this.m_bMustRepaint) {
                int n2 = 0;
                while (n2 < 2) {
                    byte by = this.m_byToCtrl[n2];
                    switch (by) {
                        case 1: {
                            n = 0;
                            break;
                        }
                        case 2: {
                            n = 1;
                            break;
                        }
                        case 4: {
                            n = 2;
                        }
                    }
                    this.m_ImgLib.paint(graphics, 1, this.m_nNextX + n2 * this.m_nTileWidth, this.m_nNextY, 0, this.m_nTimes, n * 7 + this.m_nClrBeg);
                    ++n2;
                }
                this.m_bPaintNext = false;
            }
            graphics.translate(this.m_nScrXOff, this.m_nScrYOff);
            this.PaintScene(graphics, this.m_bMustRepaint);
            graphics.translate(0, 0);
            if (this.m_nRunState == 2) {
                this.PaintMsg(graphics);
            } else if (this.m_nRunState == 3) {
                this.PaintMsg(graphics);
            }
            if (this.m_bMustRepaint) {
                this.m_bMustRepaint = false;
                this.m_Canvas.RestoreCommand();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void left() {
        if (!this.m_bCanInput) {
            return;
        }
        CMainLoop cMainLoop = this;
        synchronized (cMainLoop) {
            --this.m_nX;
            this.m_bPaintCtrl = true;
            if (this.m_nX < 0) {
                this.m_nX = 0;
            } else if (this.m_bCtrlDir) {
                int n = this.m_nX + this.m_nY * 7;
                if ((this.m_Scene[n] & 7) != 0 || (this.m_Scene[n - 7] & 7) != 0) {
                    ++this.m_nX;
                    return;
                }
                this.m_Scene[n + 1] = 0;
                this.m_Scene[n + 1 - 7] = 0;
                this.m_Scene[n] = this.m_byCtrl[0];
                this.m_Scene[n - 7] = this.m_byCtrl[1];
            } else {
                int n = this.m_nX + this.m_nY * 7;
                if ((this.m_Scene[n] & 7) != 0) {
                    ++this.m_nX;
                    return;
                }
                this.m_Scene[n + 2] = 0;
                this.m_Scene[n] = this.m_byCtrl[0];
                this.m_Scene[n + 1] = this.m_byCtrl[1];
            }
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void right() {
        if (!this.m_bCanInput) {
            return;
        }
        CMainLoop cMainLoop = this;
        synchronized (cMainLoop) {
            ++this.m_nX;
            this.m_bPaintCtrl = true;
            if (this.m_bCtrlDir) {
                if (this.m_nX >= 7) {
                    this.m_nX = 6;
                } else {
                    int n = this.m_nX + this.m_nY * 7;
                    if ((this.m_Scene[n] & 7) != 0 || (this.m_Scene[n - 7] & 7) != 0) {
                        --this.m_nX;
                        return;
                    }
                    this.m_Scene[n - 1] = 0;
                    this.m_Scene[n - 1 - 7] = 0;
                    this.m_Scene[n] = this.m_byCtrl[0];
                    this.m_Scene[n - 7] = this.m_byCtrl[1];
                }
            } else if (this.m_nX + 1 >= 7) {
                this.m_nX = 5;
            } else {
                int n = this.m_nX + this.m_nY * 7;
                if ((this.m_Scene[n + 1] & 7) != 0) {
                    --this.m_nX;
                    return;
                }
                this.m_Scene[n - 1] = 0;
                this.m_Scene[n] = this.m_byCtrl[0];
                this.m_Scene[n + 1] = this.m_byCtrl[1];
            }
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void up() {
        if (!this.m_bCanInput) {
            return;
        }
        CMainLoop cMainLoop = this;
        synchronized (cMainLoop) {
            int n = this.m_nX + this.m_nY * 7;
            if (this.m_bCtrlDir) {
                if (this.m_nX >= 6) {
                    return;
                }
                if ((this.m_Scene[n + 1] & 7) != 0) {
                    return;
                }
            } else {
                if (this.m_nY < 1) {
                    return;
                }
                if ((this.m_Scene[n - 7] & 7) != 0) {
                    return;
                }
                if ((this.m_Scene[n + 1 - 7] & 7) != 0) {
                    return;
                }
            }
            if (this.m_bCtrlDir) {
                this.m_Scene[n] = 0;
                this.m_Scene[n - 7] = 0;
            } else {
                this.m_Scene[n] = 0;
                this.m_Scene[n + 1] = 0;
            }
            if (this.m_bChgClr) {
                byte by = this.m_byCtrl[0];
                this.m_byCtrl[0] = this.m_byCtrl[1];
                this.m_byCtrl[1] = by;
                this.m_bPaintCtrl = true;
                this.m_bChgClr = false;
                this.m_bCtrlDir = !this.m_bCtrlDir;
            } else {
                this.m_bPaintCtrl = true;
                this.m_bCtrlDir = !this.m_bCtrlDir;
                this.m_bChgClr = true;
            }
            if (this.m_bCtrlDir) {
                this.m_Scene[n] = this.m_byCtrl[0];
                this.m_Scene[n - 7] = this.m_byCtrl[1];
            } else {
                this.m_Scene[n] = this.m_byCtrl[0];
                this.m_Scene[n + 1] = this.m_byCtrl[1];
            }
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void down() {
        CMainLoop cMainLoop = this;
        synchronized (cMainLoop) {
            if (this.m_bCanInput) {
                this.m_nSpeed = this.m_nSpeedMax;
            }
        }
    }
}

